<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsAtendimentoMotivo extends Elotech_Db_Table_Abstract
{
    protected $_name = 'as_atendimento_motivo';
    protected $_primary = 'asam_codigo';
    protected $_sequence = 'seq_asam_codigo';

    public function salvar($data)
    {
        try {
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                "Falha ao salvar Motivo: " . $ex->getMessage());
        }
    }

    public function excluir($asamCodigo = FALSE)
    {
        $item = $this->fetchRow("asam_codigo=$asamCodigo");
        if ($item)
            $item->delete();

        return true;
    }

    public function getDados()
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asam" => "as_atendimento_motivo"))
            ->order("asam.asam_status ASC")
            ->order("asam.asam_codigo DESC");
        return $this->fetchAll($sql);
    }

    public function getDadosPorId($asamCodigo = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asam" => "as_atendimento_motivo"))
            ->where("asam.asam_codigo =?", $asamCodigo);
        return $this->fetchRow($sql);
    }

    public function buscaGeral($term)
    {
        $sql = $this->select(FALSE)
            ->distinct()
            ->setIntegrityCheck(FALSE)
            ->from(array("asam" => "as_atendimento_motivo"), array("asam.asam_codigo", "asam.asam_nome", "asam.asam_status"))
            ->where("asam.asam_nome ilike '%$term%'")
            ->where("asam.asam_status =?", true)
            ->order("asam.asam_nome ASC");
        return $this->fetchAll($sql);
    }

    public function selecttag($asamCodigo = false)
    {
        $sql = $this->select(false)
            ->setIntegrityCheck(false)
            ->from(array("asam" => "as_atendimento_motivo"), array("asam.asam_codigo", "asam.asam_nome"))
            ->order("asam.asam_nome asc");
        return parent::selectTag($sql, "asam_nome", "asam_codigo", null, true, "asam_codigo", "dasam_asam_codigo", null, $asamCodigo);
    }

    public function getDadosPeloCodigo($asamCodigo = false)
    {
        $sql = $this->select(false)
            ->setIntegrityCheck(false)
            ->from(array("asam" => "as_atendimento_motivo"), array("asam_codigo", "asam_nome"))
            ->where("asam_codigo =?", $asamCodigo);

        return $this->fetchRow($sql);
    }

    public function getDadosPorMotivo($asamCodigo = false)
    {
        $sql = $this->select(false)
            ->setIntegrityCheck(false)
            ->from(array("asam" => "as_atendimento_motivo"), array("asam_codigo"))
            ->where("asam.asam_codigo =?", $asamCodigo);
        return $this->fetchRow($sql);
    }

    public function getDadosPorMotivoNome($asamCodigo = false, $buscarMotivo)
    {
        if ($buscarMotivo) {
            $buscarMotivo = "%" . $buscarMotivo . "%";
            $sql = $this->select(false)
                ->setIntegrityCheck(false)
                ->from(array("asam" => "as_atendimento_motivo"), array("asam_codigo", "asam_nome"))
                ->where("asam.asam_nome ilike ?", $buscarMotivo)
                ->where("asam.asam_status = 't'");
            return $this->fetchAll($sql);
        } else {
            return null;
        }
    }

//    public function getDadosNome($asamNome)
//    {
//        if ($asamNome) {
//            $sql = $this->select(false)
//                ->setIntegrityCheck(false)
//                ->from(array("asam" => "as_atendimento_motivo"), array("asam_codigo", "asam_nome"))
//                ->where("asam.asam_nome ilike ?", $asamNome);
//            return $this->fetchRow($sql);
//        } else {
//            return null;
//        }
//    }

    public function getDadosNome($nome = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asam" => "as_atendimento_motivo"), array("asam_codigo"))
            ->where("asam_nome=?", $nome);
        return $this->fetchRow($sql);
    }

    public function pesquisa($term, $stat)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asam" => "as_atendimento_motivo"));
        if ($stat !== 'Todos') {
            $stat = ($stat == 'Ativos' ? 't' : 'f');
            $sql->where("asam.asam_status =?", $stat);
        }
        $sql->where("retira_acentos(asam_nome) ilike retira_acentos('%$term%')", "S")
            ->order("asam.asam_status ASC")
            ->order("asam.asam_codigo DESC");

        //die($sql);
        return $this->fetchAll($sql);
    }

    public function validaNome($asamCodigo = false, $asamNome)
    {
        if ($asamNome && $asamCodigo) {
            $sql = $this->select(false)
                ->setIntegrityCheck(false)
                ->from(array("asam" => "as_atendimento_motivo"), array("asam_codigo", "asam_nome"))
                ->where("asam.asam_nome = ? and asam.asam_codigo = ?", $asamNome, $asamCodigo);
            return $this->fetchRow($sql);
        } else {
            return null;
        }

    }
}
