<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsAtendimentoTipo extends Elotech_Db_Table_Abstract {

    protected $_name = 'as_atendimento_tipo';
    protected $_primary = 'asat_codigo';
    protected $_sequence = 'seq_asat_codigo';

    /**
     * Retorna os dados dos atendimentos
     * @return SQL
     */
    public function selectTag($asatCodigo=FALSE, $emEdicao=FALSE) {
      $disabled = '';
      $sql = $this->select(FALSE)
              ->setIntegrityCheck(FALSE)
              ->from(array("asat" => "as_atendimento_tipo"),array("asat_codigo","asat_nome"))
              ->where("asat_situacao =?","t");

      if($emEdicao){
        $disabled = 'disabled';
      }else{
        $sql->where("asat_codigo != 6");
      }

      $sql->order("asat_nome ASC");
      return parent::selectTag($sql,"asat_nome","asat_codigo",null,true,"asat_codigo","dcab_asat_codigo",null,$asatCodigo, $disabled);
    }

    public function getDadosPeloCodigo($asatCodigo=FALSE){
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("asat" => "as_atendimento_tipo"),array("asat_codigo","asat_nome","asat_codigo_num"))
                ->where("asat_codigo =?",$asatCodigo);
        return $this->fetchRow($sql);
    }

}
