<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsAtendimentocolEncontros extends Elotech_Db_Table_Abstract {

    protected $_name = 'as_atendimentocol_encontros';
    protected $_primary = 'asae_codigo';
    protected $_sequence = 'seq_asae_codigo';

    /**
     * Salva os encontro do grupo
     * @return SQL
     */
    public function salvar($data) {
        try {
            // Limpando dados em branco
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
            "Falha ao salvar acompanhamento: " . $ex->getMessage());
        }
    }
    
    /**
     * Pega os dados dos acompanhamentos do grupo
     * @return SQL
     */
    public function getDados($asagCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("asae"=>"as_atendimentocol_encontros"),array("asae_codigo","asae_titulo","asae_dtinicio"))
                    ->join(array("asag"=>"as_atendimentocol_grupo"),"asae.asag_codigo=asag.asag_codigo",array())
                    ->join(array("ase"=>"as_estabelecimentos"),"asae.ase_codigo=ase.ase_codigo",array())
                    ->where("asae.asag_codigo =?",$asagCodigo)
                    ->order("asae.asae_codigo DESC");
        return $this->fetchAll($sql);
    }

    /**
     * Pega os dados dos participantes do grupo por id
     * @return SQL
     */
    public function getDadosPorId($asaeCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("asae"=>"as_atendimentocol_encontros"))
                    ->join(array("asag"=>"as_atendimentocol_grupo"),"asae.asag_codigo=asag.asag_codigo",array())
                    ->join(array("ase"=>"as_estabelecimentos"),"asae.ase_codigo=ase.ase_codigo",array())
                    ->where("asae.asae_codigo =?",$asaeCodigo);
        return $this->fetchRow($sql);
    }
}
