<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsAtendimentocolEncontrosHist extends Elotech_Db_Table_Abstract {

    protected $_name = 'as_atendimentocol_encontroshist';
    protected $_primary = 'asaeh_codigo';
    protected $_sequence = 'seq_asaeh_codigo';

    /**
     * Inclui os pariticipantes no evento, encontro, reunião
     * @return SQL
     */
    public function salvar($data) {
        try {
            // Limpando dados em branco
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
            "Falha ao salvar participante: " . $ex->getMessage());
        }
    }
    
    /**
     * Pega os dados dos participantes do encontro
     * @return SQL
     */
    public function getDados($asaeCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->distinct()
                    ->setIntegrityCheck(FALSE)
                    ->from(array("asaeh"=>"as_atendimentocol_encontroshist"),array("asaeh_codigo","asaeh_motivo","asaeh_presenca"))
                    ->join(array("asae"=>"as_atendimentocol_encontros"),"asaeh.asae_codigo=asae.asae_codigo",array())
                    ->join(array("usu"=>"usuario"),"asaeh.usu_codigo=usu.usu_codigo",array("usu_codigo","usu_nome","usu_datanasc","usu_fone","usu_email"))
                    ->join(array("asapar"=>"as_atendimentocol_participantes"),"usu.usu_codigo=asapar.usu_codigo",array())
                    ->where("asaeh.asae_codigo =?",$asaeCodigo)
                    ->order("asaeh_codigo DESC");
        //die($sql);
        return $this->fetchAll($sql);
    }
    
    /**
     * Pega os dados do encontro para inserção no registro de atendimento simplificado
     * @return SQL
     */
    public function getDadosPorId($asaehCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("asaeh"=>"as_atendimentocol_encontroshist"),array("asaeh_codigo"))
                    ->join(array("asae"=>"as_atendimentocol_encontros"),"asaeh.asae_codigo=asae.asae_codigo",array("asae_dtinicio"))
                    ->join(array("asag"=>"as_atendimentocol_grupo"),"asae.asag_codigo=asag.asag_codigo",array("usr_codigo"))
                    ->join(array("asap"=>"as_atendimentocol_programas"),"asag.asap_codigo=asap.asap_codigo",array("asap_num","asap_titulo"))
                    ->join(array("usu"=>"usuario"),"asaeh.usu_codigo=usu.usu_codigo",array("usu_codigo"))
                    ->join(array("asapar"=>"as_atendimentocol_participantes"),"usu.usu_codigo=asapar.usu_codigo",array())
                    ->where("asaeh.asaeh_codigo =?",$asaehCodigo);
        return $this->fetchRow($sql);
    }
    
    /**
     * Pega o status do participante
     * @return SQL
     */
    public function getStatusParticipante($asaehCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("asaeh"=>"as_atendimentocol_encontroshist"),array("asaeh_presenca"))
                    ->join(array("asae"=>"as_atendimentocol_encontros"),"asaeh.asae_codigo=asae.asae_codigo",array())
                    ->join(array("usu"=>"usuario"),"asaeh.usu_codigo=usu.usu_codigo",array())
                    ->join(array("asapar"=>"as_atendimentocol_participantes"),"usu.usu_codigo=asapar.usu_codigo",array())
                    ->where("asaeh.asaeh_codigo =?",$asaehCodigo);
        return $this->fetchRow($sql);
    }

    /**
     * Pega cidadãos participantes do grupo
     * @return SQL
     */
    public function confereCidadaoReuniao($usuCodigo=FALSE,$asaeCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("asaeh"=>"as_atendimentocol_encontroshist"),array("COUNT(asaeh_codigo) AS qtdCid"))
                    ->join(array("asae"=>"as_atendimentocol_encontros"),"asaeh.asae_codigo=asae.asae_codigo",array())
                    ->join(array("usu"=>"usuario"),"asaeh.usu_codigo=usu.usu_codigo",array())
                    ->where("asaeh.asae_codigo =?",$asaeCodigo)
                    ->where("asaeh.usu_codigo =?",$usuCodigo);
        return $this->fetchRow($sql);
    }
}
