<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsAtendimentocolGrupo extends Elotech_Db_Table_Abstract {

	protected $_name = 'as_atendimentocol_grupo';
	protected $_primary = 'asag_codigo';
	protected $_sequence = 'seq_asag_codigo';

	/**
	 * Salva os dados do grupo de atendimento coletivo
	 * @return SQL
	 */
	public function salvar($data) {
		try {
			// Limpando dados em branco
			$this->emptyToUnset($data);
			return parent::salvar($data);
		} catch (Exception $ex) {
			throw new Zend_Validate_Exception(
				"Falha ao salvar Grupo: " . $ex->getMessage());
		}
	}

	/**
	 * Retorna os dados do grupo
	 * @return SQL
	 */
	public function getDados($tipoUnidade) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("asag" => "as_atendimentocol_grupo"), array("asag_codigo", "asag_titulo", "asag_data", "asag_status", "asag_quantidade_grupo"))
			->join(array("uni" => "unidade"), "asag.uni_codigo=uni.uni_codigo", array("uni_desc"))
			->join(array("asau" => "as_atendimentocol_unidades"), "asag.asau_codigo=asau.asau_codigo", array("asau_codigo", "asau_num", "asau_titulo"))
			->join(array("asap" => "as_atendimentocol_programas"), "asag.asap_codigo=asap.asap_codigo", array("asap_codigo", "asap_num", "asap_titulo"))
			->where("uni.uni_astipo = '$tipoUnidade'")
			->order("asag.asag_titulo ASC")
			->limit(500);
		return $this->fetchAll($sql);
	}

	/**
	 * Retorna os dados do grupo
	 * @return SQL
	 */
	public function getDadosGrupo($asagCodigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(
				array("asag" => "as_atendimentocol_grupo"),
				array("asag_codigo", "asag_titulo", "asag_data",
					"asag_status" => (new Zend_Db_Expr("(CASE WHEN asag_status = true THEN 't' ELSE 'f' END)")),
					"asag_quantidade_grupo", "(0) as qtde_part", "asap_codigo", "asau_codigo")
			)
			->join(array("uni" => "unidade"), "asag.uni_codigo=uni.uni_codigo", array("uni_codigo", "uni_desc"))
			->join(array("usr" => "usuarios"), "asag.usr_codigo=usr.usr_codigo", array("usr_codigo", "usr_nome"))
			->join(array("asau" => "as_atendimentocol_unidades"), "asag.asau_codigo=asau.asau_codigo", array("asau_codigo", "asau_num", "asau_titulo"))
			->join(array("asap" => "as_atendimentocol_programas"), "asag.asap_codigo=asap.asap_codigo", array("asap_codigo", "asap_num", "asap_titulo"))
			->where("asag.asag_codigo =?", $asagCodigo)
			->order("asag.asag_titulo ASC");
		$dados = $this->fetchRow($sql);
		$dados->__set("qtde_part", $this->getQtdeParticipante($asagCodigo));
		return $dados;
	}

	public function getQtdeParticipante($asag_codigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("asapar" => "as_atendimentocol_participantes"), array("qtde_part" => "COUNT(asapar.asag_codigo)"))
			->join(array("asag" => "as_atendimentocol_grupo"), "asapar.asag_codigo = asag.asag_codigo", "")
			->join(array("usu" => "usuario"), "asapar.usu_codigo = usu.usu_codigo", "")
			->where("asapar.asag_codigo = " . $asag_codigo)
			->where("asapar.asapar_status = 't'");
		return $this->fetchRow($sql)->qtde_part;
	}

	/**
	 * Retorna os dados da busca autocomplete
	 * @return SQL
	 */
	public function buscaDados($term, $tipoUnidade) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("asag" => "as_atendimentocol_grupo"), array("asag_codigo", "asag_titulo", "asag_data", "asag_quantidade_grupo"))
			->join(array("uni" => "unidade"), "asag.uni_codigo=uni.uni_codigo", array("uni_desc"))
			->join(array("asau" => "as_atendimentocol_unidades"), "asag.asau_codigo=asau.asau_codigo", array("asau_codigo", "asau_num", "asau_titulo"))
			->join(array("asap" => "as_atendimentocol_programas"), "asag.asap_codigo=asap.asap_codigo", array("asap_codigo", "asap_num", "asap_titulo"))
			->where("asag_titulo ILIKE '%$term%'")
			->where("uni.uni_astipo = '$tipoUnidade'")
			->where("asag_status = 't'");
		return $this->fetchAll($sql);
	}

	/**
	 * Exclui os dados do benefício do cidadão pelo código
	 * @return SQL
	 */
	public function excluir($asagCodigo = FALSE) {
		$item = $this->fetchRow("asag_codigo=$asagCodigo");
		if ($item)
			$item->delete();

		return true;
	}

	public function pesquisaDados($busca) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("asenc" => "as_encaminhamento"), array("asenc_codigo", "asenc_motivo", "asenc_data"))
			->join(array("asec" => "as_encaminhamento_codigos"), "asenc.asec_codigo=asec.asec_codigo", array("asec_codigo", "asec_num", "asec_titulo"))
			->join(array("uni" => "unidade"), "asenc.uni_codigo=uni.uni_codigo", array("uni_codigo", "uni_desc"))
			->join(array("ase" => "as_estabelecimentos"), "asenc.ase_codigo=ase.ase_codigo", array("ase_codigo", "ase_nome", "ase_logradouro", "ase_num", "ase_bairro"))
			->join(array("usu" => "usuario"), "asenc.usu_codigo=usu.usu_codigo", array("usu_codigo", "usu_nome"))
			->join(array("usr" => "usuarios"), "asenc.usr_codigo=usr.usr_codigo", array("usr_codigo", "usr_nome"))
			->where("uni.uni_desc ILIKE '%$busca%' OR usu.usu_nome ILIKE '%$busca%' OR usr.usr_nome ILIKE '%$busca%'")
			->limit(500);
		//die($sql);
		return $this->fetchAll($sql);
	}

}
