<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsAtendimentocolParticipantes extends Elotech_Db_Table_Abstract {

    protected $_name = 'as_atendimentocol_participantes';
    protected $_primary = 'asapar_codigo';
    protected $_sequence = 'seq_asapar_codigo';

    /**
     * Salva os pariticipantes como integrantes do grupo
     * @return SQL
     */
    public function salvar($data) {
        try {
            // Limpando dados em branco
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
            "Falha ao salvar participante: " . $ex->getMessage());
        }
    }
    
    /**
     * Pega os dados dos participantes do grupo
     * @return SQL
     */
    public function getDados($asagCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("asapar"=>"as_atendimentocol_participantes"),array("asapar_codigo","asapar_status","asapar_dtingresso","asapar_dtsaida"))
                    ->join(array("asag"=>"as_atendimentocol_grupo"),"asapar.asag_codigo=asag.asag_codigo",array("asag_codigo","asag_titulo"))
                    ->join(array("usu"=>"usuario"),"asapar.usu_codigo=usu.usu_codigo",array("usu_codigo","usu_nome","usu_datanasc","usu_fone"))
                    ->where("asapar.asag_codigo =$asagCodigo")
                    ->order("usu_nome ASC");
        return $this->fetchAll($sql);
    }

    /**
     * Pega os dados dos participantes do grupo por id
     * @return SQL
     */
    public function getDadosPorId($asaparCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("asapar"=>"as_atendimentocol_participantes"),array("asapar_codigo","asapar_status","asapar_dtingresso","asapar_dtsaida"))
                    ->join(array("asag"=>"as_atendimentocol_grupo"),"asapar.asag_codigo=asag.asag_codigo",array("asag_codigo","asag_titulo"))
                    ->join(array("usu"=>"usuario"),"asapar.usu_codigo=usu.usu_codigo",array("usu_codigo","usu_nome","usu_datanasc","usu_fone"))
                    ->where("asapar.asapar_codigo =?",$asaparCodigo);
        return $this->fetchRow($sql);
    }
    
    /**
     * Pega cidadãos participantes do grupo
     * @return SQL
     */
    public function getCidadaosPorGrupo($asagCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("asapar"=>"as_atendimentocol_participantes"),array("usu_codigo"))
                    ->join(array("asag"=>"as_atendimentocol_grupo"),"asapar.asag_codigo=asag.asag_codigo",array())
                    ->join(array("usu"=>"usuario"),"asapar.usu_codigo=usu.usu_codigo",array())
                    ->where("asapar.asag_codigo =?",$asagCodigo)
                    ->where("asapar.asapar_status = 't'");
        return $this->fetchAll($sql);
    }
    
    /**
     * Pega cidadãos participantes do grupo
     * @return SQL
     */
    public function confereCidadaoReuniao($asagCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("asapar"=>"as_atendimentocol_participantes"),array("usu_codigo"))
                    ->join(array("asag"=>"as_atendimentocol_grupo"),"asapar.asag_codigo=asag.asag_codigo",array())
                    ->join(array("usu"=>"usuario"),"asapar.usu_codigo=usu.usu_codigo",array())
                    ->where("asapar.asag_codigo =?",$asagCodigo);
        return $this->fetchAll($sql);
    }
}
