<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsAtendimentocolProgramas extends Elotech_Db_Table_Abstract {

    protected $_name = 'as_atendimentocol_programas';
    protected $_primary = 'asap_codigo';
    protected $_sequence = 'seq_asap_codigo';

    /**
     * Salva os dados do programa de atendimento
     * @return SQL
     */
    public function salvar($data) {
        try {
            // Limpando dados em branco
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
            "Falha ao salvar Programa: " . $ex->getMessage());
        }
    }

    /**
     * Retorna os programas em um select 
     * @return SQL
     */
    public function selectTag($selecionado) {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("asap" => "as_atendimentocol_programas"),array("asap_codigo","asap_titulo"))
                ->order("asap_titulo ASC");
        return parent::selectTag($sql,"asap_titulo","asap_codigo",null,true,"asap_codigo","dcg_asap_codigo",null,$selecionado);
    }

}
