<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsAtendimentocolRespencontro extends Elotech_Db_Table_Abstract {

    protected $_name = 'as_atendimentocol_respencontro';
    protected $_primary = 'asar_codigo';
    protected $_sequence = 'seq_asar_codigo';

    /**
     * Salva os dados dos profissionais responsável pelo encontro
     * @return SQL
     */
    public function salvar($data) {
        try {
            // Limpando dados em branco
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
            "Falha ao salvar responsaveis: " . $ex->getMessage());
        }
    }
    
    /**
     * Pega os dados dos profissionais responsável pelo encontro
     * @return SQL
     */
    public function getDados($asaeCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("asar"=>"as_atendimentocol_respencontro"),array("asar_codigo"))
                    ->join(array("asae"=>"as_atendimentocol_encontros"),"asar.asae_codigo=asae.asae_codigo",array("asae_codigo","asae_titulo"))
                    ->join(array("usr"=>"usuarios"),"asar.usr_codigo=usr.usr_codigo",array("usr_codigo","usr_nome","usr_celular"))
                    ->where("asar.asae_codigo =?",$asaeCodigo);
        return $this->fetchAll($sql);
    }
    
    /**
     * Pega os dados dos profissionais e exclui do encontro
     * @return SQL
     */
    public function excluir($asarCodigo=FALSE) {
        $item = $this->fetchRow("asar_codigo=$asarCodigo");
        if ($item) {
            $item->delete();
        }
    }

}
