<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsAtendimentocolUnidades extends Elotech_Db_Table_Abstract {

    protected $_name = 'as_atendimentocol_unidades';
    protected $_primary = 'asau_codigo';
    protected $_sequence = 'seq_asau_codigo';

    /**
     * Salva os dados do programa de atendimento
     * @return SQL
     */
    public function salvar($data) {
        try {
            // Limpando dados em branco
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
            "Falha ao salvar Programa: " . $ex->getMessage());
        }
    }

    /**
     * Retorna as unidade do grupo em um select 
     * @return SQL
     */
    public function selectTag($selecionado) {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("asau" => "as_atendimentocol_unidades"),array("asau_codigo","asau_titulo"))
                ->order("asau_titulo ASC");
        return parent::selectTag($sql,"asau_titulo","asau_codigo",null,true,"asau_codigo","dcg_asau_codigo",null,$selecionado);
    }

}
