<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsBeneficiosDados extends Elotech_Db_Table_Abstract {

	protected $_name = 'as_beneficios_dados';
	protected $_primary = 'asbd_codigo';
	protected $_sequence = 'seq_asbd_codigo';

	/**
	 * Salva os dados de beneficio do cidadão
	 * @return SQL
	 */
	public function salvar($data) {
		try {
			$this->emptyToUnset($data);
			return parent::salvar($data);
		} catch (Exception $ex) {
			die($ex->getMessage());
			throw new Zend_Validate_Exception("Falha ao salvar Benefício: " . $ex->getMessage());
		}
	}

	/**
	 * Retorna os dados do benefício do cidadão pelo código
	 * @return SQL
	 */
	public function getDados($tipoUnidade, $usr_codigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("asbd" => "as_beneficios_dados"))
			->join(array("uni" => "unidade"), "asbd.uni_codigo=uni.uni_codigo", array("uni_codigo", "uni_desc"))
			->join(array("usu" => "usuario"), "asbd.usu_codigo=usu.usu_codigo", array("usu_codigo", "usu_sexo", "usu_nome", "usu_mae", "usu_pai", "usu_datanasc" => "to_char(usu_datanasc,'DD/MM/YYYY')", "usu_prontuario", "usu_cartao_sus", "usu_bloqueado", "usu_nome_resp"))
			->join(array("usr" => "usuarios"), "asbd.usr_codigo=usr.usr_codigo", array("usr_codigo", "usr_nome"))
			->join(array("ase" => "as_estabelecimentos"), "asbd.ase_codigo=ase.ase_codigo", array("ase_codigo", "ase_nome"))
			->where("uni.uni_astipo = '$tipoUnidade'")
			->where("usr.usr_codigo = $usr_codigo")
			->order("asbd_codigo DESC")
			->limit(1000);
		return $this->fetchAll($sql);
	}

	/**
	 * Retorna os dados do benefício do cidadão pelo código
	 * @return SQL
	 */
	public function getDadosPorId($asbdCodigo = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("asbd" => "as_beneficios_dados"))
			->join(array("uni" => "unidade"), "asbd.uni_codigo=uni.uni_codigo", array("uni_codigo", "uni_desc"))
			->join(array("usu" => "usuario"), "asbd.usu_codigo=usu.usu_codigo", array("usu_codigo", "usu_sexo", "usu_nome", "usu_mae", "usu_pai", "usu_datanasc" => "to_char(usu_datanasc,'DD/MM/YYYY')", "usu_prontuario", "usu_cartao_sus", "usu_bloqueado", "usu_nome_resp"))
			->join(array("usr" => "usuarios"), "asbd.usr_codigo=usr.usr_codigo", array("usr_codigo", "usr_nome"))
			->join(array("ase" => "as_estabelecimentos"), "asbd.ase_codigo=ase.ase_codigo", array("ase_codigo", "ase_nome"))
			->joinLeft(array("dom" => "domicilio"), "dom.dom_codigo=usu.dom_codigo", array("dom_numero"))
			->joinLeft("rua", "rua.rua_codigo=dom.rua_codigo", array("rua_nome", "rua_bairro"))
			->joinLeft(array("cid" => "cidade"), "cid.cid_codigo=rua.cid_codigo", array("cid_nome"))
			->where("asbd.asbd_codigo =?", $asbdCodigo)
			->limit(500);
		return $this->fetchRow($sql);
	}

	/**
	 * Exclui os dados do benefício do cidadão pelo código
	 * @return SQL
	 */
	public function excluir($asabCodigo = FALSE) {
		$item = $this->fetchRow("asbc_codigo=$asabCodigo");
		if ($item)
			$item->delete();

		return true;
	}

	public function getDadosPesquisa($busca, $tipoUnidade, $usr_codigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("asbd" => "as_beneficios_dados"))
			->join(array("uni" => "unidade"), "asbd.uni_codigo=uni.uni_codigo", array("uni_codigo", "uni_desc"))
			->join(array("usu" => "usuario"), "asbd.usu_codigo=usu.usu_codigo", array("usu_codigo", "usu_sexo", "usu_nome", "usu_mae", "usu_pai", "usu_datanasc" => "to_char(usu_datanasc,'DD/MM/YYYY')", "usu_prontuario", "usu_cartao_sus", "usu_bloqueado", "usu_nome_resp"))
			->join(array("usr" => "usuarios"), "asbd.usr_codigo=usr.usr_codigo", array("usr_codigo", "usr_nome"))
			->join(array("ase" => "as_estabelecimentos"), "asbd.ase_codigo=ase.ase_codigo", array("ase_codigo", "ase_nome"))
			->where("uni.uni_astipo = '$tipoUnidade'")
			->where("usr.usr_codigo = $usr_codigo")
			->order("asbd_codigo DESC");

		$tbFun = new Application_Model_Funcoes();
		if ($tbFun->ValidaData($busca) == 1) {
			$sql->where("to_char(asbd_dtcadastro,'DD/MM/YYYY') ='$busca'");
		} else {
			$sql->where("ase.ase_nome ILIKE '%$busca%' OR usu.usu_nome ILIKE '%$busca%' OR usr.usr_nome ILIKE '%$busca%' OR uni.uni_desc ILIKE '%$busca%'");
		}
		return $this->fetchAll($sql);
	}

	/**
	 * Retorna os benefícios recebidos pelo cidadão
	 * @return SQL
	 */
    public function getDadosPorProntuarioSuas($aspsCodigo = FALSE) {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->distinct()
            ->from(array("asbd" => "as_beneficios_dados"))
            ->join(array("uni" => "unidade"), "asbd.uni_codigo=uni.uni_codigo", array("uni_codigo", "uni_desc"))
            ->join(array("usu" => "usuario"), "asbd.usu_codigo=usu.usu_codigo", array("usu_codigo", "usu_sexo", "usu_nome", "usu_mae", "usu_pai", "usu_datanasc" => "to_char(usu_datanasc,'DD/MM/YYYY')", "usu_prontuario", "usu_cartao_sus", "usu_bloqueado", "usu_nome_resp"))
            ->join(array("aspsu" => "as_prontuario_suas_usuario"), "aspsu.usu_codigo=usu.usu_codigo", "")
            ->join(array("usr" => "usuarios"), "asbd.usr_codigo=usr.usr_codigo", array("usr_codigo", "usr_nome"))
            ->join(array("ase" => "as_estabelecimentos"), "asbd.ase_codigo=ase.ase_codigo", array("ase_codigo", "ase_nome"))
            ->joinLeft(array("dom" => "domicilio"), "dom.dom_codigo=usu.dom_codigo", array("dom_numero"))
            ->joinLeft("rua", "rua.rua_codigo=dom.rua_codigo", array("rua_nome", "rua_bairro"))
            ->joinLeft(array("cid" => "cidade"), "cid.cid_codigo=rua.cid_codigo", array("cid_nome"))
            ->where("aspsu.asps_codigo =?", $aspsCodigo);
        return $this->fetchAll($sql);
    }

}
