<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsBeneficiosDadosItens extends Elotech_Db_Table_Abstract {

    protected $_name = 'as_beneficios_dados_itens';
    protected $_primary = 'asbdi_codigo';
    protected $_sequence = 'seq_asbdi_codigo';

    /**
     * Salva os dados de beneficio do cidadão
     * @return SQL
     */
    public function salvar($data) {
        try {
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            die($ex->getMessage());
            throw new Zend_Validate_Exception("Falha ao salvar Itens Benefício: " . $ex->getMessage());
        }
    }
    
    /**
     * Retorna os dados do benefício do cidadão pelo código
     * @return SQL
     */
    public function getDadosPorId($asbdCodigo = FALSE) {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->distinct()
                ->from(array("asbdi" => "as_beneficios_dados_itens"))
                ->join(array("asbd"=>"as_beneficios_dados"),"asbdi.asbd_codigo=asbd.asbd_codigo",array("asbd_codigo"))
                ->join(array("ben"=>"beneficios"),"asbdi.cod_ben=ben.cod_ben",array("cod_ben","beneficio"))
                ->join(array("asbt"=>"as_beneficios_tipo"),"asbdi.asbt_codigo=asbt.asbt_codigo",array("asbt_codigo","asbt_nome"))
                ->join(array("ase"=>"as_estabelecimentos"),"asbd.ase_codigo=ase.ase_codigo",array("ase_codigo","ase_nome"))
                ->where("asbdi.asbd_codigo =?",$asbdCodigo);
        return $this->fetchAll($sql);
    }

	/**
     * Exclui os dados do benefício do cidadão pelo código
     * @return SQL
     */
    public function excluir($asbdiCodigo = FALSE) {
        $item = $this->fetchRow("asbdi_codigo=$asbdiCodigo");
        if ($item)
            $item->delete();

        return true;
    }
    
    /**
     * Retorna os benefícios recebidos pelo cidadão
     * @return SQL
     */
    public function getBeneficiosFamilia($usuCodigos = FALSE) {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->distinct()
                ->from(array("asbdi" => "as_beneficios_dados_itens"),array(""))
                ->join(array("asbd"=>"as_beneficios_dados"),"asbdi.asbd_codigo=asbd.asbd_codigo",array("asbd_codigo","asbd_dtcadastro"))
                ->join(array("usr"=>"usuarios"),"asbd.usr_codigo=usr.usr_codigo",array("usr_codigo","usr_nome"))
                ->join(array("usu"=>"usuario"),"asbd.usu_codigo=usu.usu_codigo",array("usu_codigo","usu_nome"))
                ->join(array("ben"=>"beneficios"),"asbdi.cod_ben=ben.cod_ben",array("cod_ben","beneficio"))
                ->where("asbd.usu_codigo IN ($usuCodigos)")
                ->order("asbd.asbd_codigo DESC")
                ->limit(5);
        return $this->fetchAll($sql);
    }
    
    


}
