<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsBeneficiosTipo extends Elotech_Db_Table_Abstract
{

    protected $_name = 'as_beneficios_tipo';
    protected $_primary = 'asbt_codigo';
    protected $_sequence = 'seq_asbt_codigo';

    /**
     * Retorna os tipos de beneficios em um select
     * @return SQL
     */
    public function selectTag($asbtCodigo = FALSE, $disabled='')
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asbt" => "as_beneficios_tipo"), array("asbt_codigo", "asbt_nome"))
            ->where("asbt_situacao =?", "t")
            ->order("asbt_nome ASC");
        return parent::selectTag($sql, "asbt_nome", "asbt_codigo", null, true, "asbt_codigo", "dcab_asbt_codigo", null, $asbtCodigo, $disabled);
    }

}
