<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsCondicaoMoradiaAtual extends Elotech_Db_Table_Abstract {

    protected $_name = 'as_condicao_moradia_atual';
    protected $_primary = 'conmoratu_codigo';
    //protected $_sequence = 'seq_asenc_codigo';

    
         /**
    * Retorna a composição familiar do prontuário SUAS
    * @param int $aspsCodigo
    * @return Zend_Db_Table_Row_Abstract
    */
    public function getDadosComposicaoFamiliarHabitacional($aspsCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("asps"=>"as_prontuario_suas"),array())
                    ->joinLeft(array("assofa"=>"as_aspectos_sociais_familia"),"asps.asps_codigo=assofa.asps_codigo",array("assofa_tipo_adaptacao"))
                    ->joinLeft(array("conmoratu"=>"as_condicao_moradia_atual"),"asps.asps_codigo=conmoratu.asps_codigo")
                    ->joinLeft(array("asproc"=>"as_procedencia"),"asps.asps_codigo=asproc.asps_codigo",array())
                    ->joinLeft(array("aspsu"=>"as_prontuario_suas_usuario"),"asps.asps_codigo=aspsu.asps_codigo",array())
                    ->joinLeft(array("usu"=>"usuario"),"aspsu.usu_codigo=usu.usu_codigo",array("usu_codigo"))
                    ->where("asps.asps_codigo =?",$aspsCodigo)
                    ->order("conmoratu.conmoratu_codigo DESC")
                    ->limit(1);
        
        return $this->fetchRow($sql);
    }
    
    /**
     * Salva os dados de encaminhamento
     * @return SQL
     */
    public function salvar($data) {
        try {
            // Limpando dados em branco
            $this->emptyToNull($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
            "Falha ao salvar Encaminhamento: " . $ex->getMessage());
        }
    }

    /**
     * Retorna os dados de encaminhamento
     * @return SQL
     */
    public function getDados() {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("asenc" => "as_encaminhamento"),array("asenc_codigo","asenc_motivo","asenc_data"))
                ->join(array("asec"=>"as_encaminhamento_codigos"),"asenc.asec_codigo=asec.asec_codigo",array("asec_codigo","asec_num","asec_titulo"))
                ->join(array("uni"=>"unidade"),"asenc.uni_codigo=uni.uni_codigo",array("uni_codigo","uni_desc"))
                ->join(array("ase"=>"as_estabelecimentos"),"asenc.ase_codigo=ase.ase_codigo",array("ase_codigo","ase_nome"))
                ->join(array("usu"=>"usuario"),"asenc.usu_codigo=usu.usu_codigo",array("usu_codigo","usu_nome"))
                ->join(array("usr"=>"usuarios"),"asenc.usr_codigo=usr.usr_codigo",array("usr_codigo","usr_nome"))
                ->order("asenc.asenc_codigo DESC");
        return $this->fetchAll($sql);
    }

    /**
     * Retorna os dados do benefício do cidadão pelo código
     * @return SQL
     */
    public function getDadosPorId($asencCodigo = FALSE) {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("asenc" => "as_encaminhamento"),array("asenc_codigo","asenc_motivo","asenc_data"))
                ->join(array("asec"=>"as_encaminhamento_codigos"),"asenc.asec_codigo=asec.asec_codigo",array("asec_codigo","asec_num","asec_titulo"))
                ->join(array("uni"=>"unidade"),"asenc.uni_codigo=uni.uni_codigo",array("uni_codigo","uni_desc","cnes_telefone"))
                ->join(array("ase"=>"as_estabelecimentos"),"asenc.ase_codigo=ase.ase_codigo",array("ase_codigo","ase_nome","ase_logradouro","ase_num","ase_bairro"))
                ->join(array("usu"=>"usuario"),"asenc.usu_codigo=usu.usu_codigo",array("usu_codigo","usu_nome"))
                ->join(array("usr"=>"usuarios"),"asenc.usr_codigo=usr.usr_codigo",array("usr_codigo","usr_nome"))
                ->where("asenc.asenc_codigo =?", $asencCodigo)
                ->limit(500);
        return $this->fetchRow($sql);
    }

    /**
     * Exclui os dados do benefício do cidadão pelo código
     * @return SQL
     */
    public function excluir($asabCodigo = FALSE) {
        $item = $this->fetchRow("asbc_codigo=$asabCodigo");
        if ($item)
            $item->delete();

        return true;
    }
    
    public function pesquisaDados($busca) {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("asenc" => "as_encaminhamento"),array("asenc_codigo","asenc_motivo","asenc_data"))
                ->join(array("asec"=>"as_encaminhamento_codigos"),"asenc.asec_codigo=asec.asec_codigo",array("asec_codigo","asec_num","asec_titulo"))
                ->join(array("uni"=>"unidade"),"asenc.uni_codigo=uni.uni_codigo",array("uni_codigo","uni_desc"))
                ->join(array("ase"=>"as_estabelecimentos"),"asenc.ase_codigo=ase.ase_codigo",array("ase_codigo","ase_nome","ase_logradouro","ase_num","ase_bairro"))
                ->join(array("usu"=>"usuario"),"asenc.usu_codigo=usu.usu_codigo",array("usu_codigo","usu_nome"))
                ->join(array("usr"=>"usuarios"),"asenc.usr_codigo=usr.usr_codigo",array("usr_codigo","usr_nome"))
                ->where("uni.uni_desc ILIKE '%$busca%' OR usu.usu_nome ILIKE '%$busca%' OR usr.usr_nome ILIKE '%$busca%' OR ase_nome ILIKE '%$busca%'")
                ->limit(500);
        //die($sql);
        return $this->fetchAll($sql);
    }

}
