<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsEncaminhamento extends Elotech_Db_Table_Abstract {

	protected $_name = 'as_encaminhamento';
	protected $_primary = 'asenc_codigo';
	protected $_sequence = 'seq_asenc_codigo';

	/**
	 * Salva os dados de encaminhamento
	 * @return SQL
	 */
	public function salvar($data) {
		try {
			// Limpando dados em branco
			$this->emptyToUnset($data);
			return parent::salvar($data);
		} catch (Exception $ex) {
			throw new Zend_Validate_Exception(
				"Falha ao salvar Encaminhamento: " . $ex->getMessage());
		}
	}

	/**
	 * Retorna os dados de encaminhamento
	 * @return SQL
	 */
	public function getDados($tipoUnidade, $usr_codigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("asenc" => "as_encaminhamento"), array("asenc_codigo", "asenc_motivo", "asenc_data"))
			->join(array("asec" => "as_encaminhamento_codigos"), "asenc.asec_codigo=asec.asec_codigo", array("asec_codigo", "asec_num", "asec_titulo"))
			->join(array("uni" => "unidade"), "asenc.uni_codigo=uni.uni_codigo", array("uni_codigo", "uni_desc"))
			->join(array("ase" => "as_estabelecimentos"), "asenc.ase_codigo=ase.ase_codigo", array("ase_codigo", "ase_nome"))
			->join(array("usu" => "usuario"), "asenc.usu_codigo=usu.usu_codigo", array("usu_codigo", "usu_nome"))
			->join(array("usr" => "usuarios"), "asenc.usr_codigo=usr.usr_codigo", array("usr_codigo", "usr_nome"))
			->where("uni.uni_astipo = '$tipoUnidade'")
			->where("usr.usr_codigo = $usr_codigo")
			->order("asenc.asenc_codigo DESC")
			->limit(500);
		return $this->fetchAll($sql);
	}

	/**
	 * Retorna os dados do benefício do cidadão pelo código
	 * @return SQL
	 */
	public function getDadosPorId($asencCodigo = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("asenc" => "as_encaminhamento"), array("asenc_codigo", "asenc_motivo", "asenc_data"))
			->join(array("asec" => "as_encaminhamento_codigos"), "asenc.asec_codigo=asec.asec_codigo", array("asec_codigo", "asec_num", "asec_titulo"))
			->join(array("uni" => "unidade"), "asenc.uni_codigo=uni.uni_codigo", array("uni_codigo", "uni_desc", "cnes_telefone"))
			->join(array("ase" => "as_estabelecimentos"), "asenc.ase_codigo=ase.ase_codigo", array("ase_codigo", "ase_nome", "ase_logradouro", "ase_num", "ase_bairro"))
			->join(array("usu" => "usuario"), "asenc.usu_codigo=usu.usu_codigo", array("usu_codigo", "usu_nome"))
			->join(array("usr" => "usuarios"), "asenc.usr_codigo=usr.usr_codigo", array("usr_codigo", "usr_nome"))
			->where("asenc.asenc_codigo =?", $asencCodigo)
			->limit(500);
		return $this->fetchRow($sql);
	}

	/**
	 * Exclui os dados do benefício do cidadão pelo código
	 * @return SQL
	 */
	public function excluir($asabCodigo = FALSE) {
		$item = $this->fetchRow("asbc_codigo=$asabCodigo");
		if ($item)
			$item->delete();

		return true;
	}

	public function pesquisaDados($busca, $tipoUnidade, $usr_codigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("asenc" => "as_encaminhamento"), array("asenc_codigo", "asenc_motivo", "asenc_data"))
			->join(array("asec" => "as_encaminhamento_codigos"), "asenc.asec_codigo=asec.asec_codigo", array("asec_codigo", "asec_num", "asec_titulo"))
			->join(array("uni" => "unidade"), "asenc.uni_codigo=uni.uni_codigo", array("uni_codigo", "uni_desc"))
			->join(array("ase" => "as_estabelecimentos"), "asenc.ase_codigo=ase.ase_codigo", array("ase_codigo", "ase_nome", "ase_logradouro", "ase_num", "ase_bairro"))
			->join(array("usu" => "usuario"), "asenc.usu_codigo=usu.usu_codigo", array("usu_codigo", "usu_nome"))
			->join(array("usr" => "usuarios"), "asenc.usr_codigo=usr.usr_codigo", array("usr_codigo", "usr_nome"))
			->where("uni.uni_desc ILIKE '%$busca%' OR usu.usu_nome ILIKE '%$busca%' OR usr.usr_nome ILIKE '%$busca%' OR ase_nome ILIKE '%$busca%'")
			->where("uni.uni_astipo = '$tipoUnidade'")
			->where("usr.usr_codigo = $usr_codigo")
			->limit(500);
		//die($sql);
		return $this->fetchAll($sql);
	}

    public function getDadosPorProntuarioSuas($aspsCodigo = FALSE) {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asenc" => "as_encaminhamento"), array("asenc_codigo", "asenc_motivo", "asenc_data"))
            ->join(array("asec" => "as_encaminhamento_codigos"), "asenc.asec_codigo=asec.asec_codigo", array("asec_codigo", "asec_num", "asec_titulo"))
            ->join(array("uni" => "unidade"), "asenc.uni_codigo=uni.uni_codigo", array("uni_codigo", "uni_desc", "cnes_telefone"))
            ->join(array("ase" => "as_estabelecimentos"), "asenc.ase_codigo=ase.ase_codigo", array("ase_codigo", "ase_nome", "ase_logradouro", "ase_num", "ase_bairro"))
            ->join(array("usu" => "usuario"), "asenc.usu_codigo=usu.usu_codigo", array("usu_codigo", "usu_nome"))
            ->join(array("aspsu" => "as_prontuario_suas_usuario"), "aspsu.usu_codigo=usu.usu_codigo", "")
            ->join(array("usr" => "usuarios"), "asenc.usr_codigo=usr.usr_codigo", array("usr_codigo", "usr_nome"))
            ->where("aspsu.asps_codigo =?", $aspsCodigo);
        return $this->fetchAll($sql);
    }
}
