<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsEstabelecimentos extends Elotech_Db_Table_Abstract {

    protected $_name = 'as_estabelecimentos';
    protected $_primary = 'ase_codigo';
    protected $_sequence = 'seq_ase_codigo';

    /**
     * Salva os dados do estabelecimento
     * @return SQL
     */
    public function salvar($data) {
        try {
            // Limpando dados em branco
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
            "Falha ao salvar Estabelecimento: " . $ex->getMessage());
        }
    }

    /**
     * Retorna os dados dos estabelecimento
     * @return SQL
     */
    public function getDados() {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("ase" => "as_estabelecimentos"))
                ->order("ase_codigo ASC");
        return $this->fetchAll($sql);
    }

    /**
     * Retorna os dados do estabelecimento por código
     * @return SQL
     */
    public function getDadosPorId($aseCodigo = FALSE) {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("ase" => "as_estabelecimentos"))
                ->where("ase.ase_codigo =?", $aseCodigo);
        return $this->fetchRow($sql);
    }

    /**
     * Exclui os dados do estabelecimento
     * @return SQL
     */
    public function excluir($aseCodigo = FALSE) {
        $item = $this->fetchRow("ase_codigo=$aseCodigo");
        if ($item)
            $item->delete();

        return true;
    }
    
    /**
     * Retorna os estabelecimentos em um select 
     * @return SQL
     */
    public function selectTag($aseCodigo=FALSE, $disabled='') {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("ase" => "as_estabelecimentos"),array("ase_codigo","ase_nome"))
                ->where("ase_situacao =?","t")
                ->order("ase_nome ASC");
        return parent::selectTag($sql,"ase_nome","ase_codigo",null,true,"ase_codigo","dcbe_ase_codigo",null,$aseCodigo, $disabled);
    }

    public function pesquisa($term, $stat) {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("ase" => "as_estabelecimentos"));
        if($stat !== "Todos"){
            $stat = ($stat === "Ativos" ? 't' : 'f');
            $sql->where("ase.ase_situacao =?", $stat);
        }
        if(strlen($term) > 0){
            $sql->where("retira_acentos(ase_nome) ilike retira_acentos('%$term%')", "S");
        }
        $sql->order("ase_codigo ASC");

        return $this->fetchAll($sql);
    }

}
