<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsGrupoUsuarios extends Elotech_Db_Table_Abstract
{

    protected $_name = 'as_grupo_usuarios';
    protected $_primary = 'asgpu_codigo';

    public function getGrupos()
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asgpu" => "as_grupo_usuarios"));
        return $this->fetchAll($sql);
    }

    public function getGrupo($asgpu_codigo = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asgpu" => "as_grupo_usuarios"))
            ->where("asgpu_codigo = $asgpu_codigo");
        return $this->fetchRow($sql);
    }

    public function getGrupoPorNome($term)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asgpu" => "as_grupo_usuarios"))
            ->where("asgpu_desc = '$term'");
        return $this->fetchAll($sql);

    }
    public function getGrupoPesquisa($term)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asgpu" => "as_grupo_usuarios"))
            ->where("asgpu_desc ilike '%$term%'");
        return $this->fetchAll($sql);

    }

    public function salvar($data)
    {
        try {
            // Limpando dados em branco
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                "Falha ao salvar Grupo: " . $ex->getMessage());
        }
    }
    public function excluir($asgpu_codigo){
        try{
            // Exclui todas os participantes do grupo para excluir o grupo.
            $tbGruPart = new Application_Model_AsGrupoUsuariosParticipante();
            $participantes = $tbGruPart->getParticipantes($asgpu_codigo);
            foreach ($participantes as $key => $part) {
                $tbGruPart->excluir($participantes[$key]['asgpp_codigo']);
            }
            //Exclui o grupo
            $item = $this->fetchRow("asgpu_codigo = $asgpu_codigo");
            if ($item) {
                $item->delete();
            }

        }catch (Exception $ex){
            throw new Zend_Validate_Exception("Falha ao excluir Grupo: " . $ex->getMessage());
        }
    }

}
