<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsGrupoUsuariosParticipante extends Elotech_Db_Table_Abstract {

    protected $_name = 'as_grupo_usuarios_participante';
    protected $_primary = 'asgpp_codigo';

    public function salvar($data)
    {
        try {
            // Limpando dados em branco
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                "Falha ao salvar Participante: " . $ex->getMessage());
        }
    }

    public function getParticipantes($asgpu_codigo){
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asgpp" => "as_grupo_usuarios_participante"))
            ->join(array("usr" =>"usuarios"),"asgpp.usr_codigo = usr.usr_codigo", array("usr_nome"))
            ->joinLeft(array("crg" =>"cargos"),"usr.crg_codigo = crg.crg_codigo AND crg.crg_status IS TRUE", array("crg_nome"))
            ->where("asgpu_codigo = $asgpu_codigo");
        return $this->fetchAll($sql);
    }

    public function excluir($asgpp_codigo){
        try{
            $item = $this->fetchRow("asgpp_codigo = $asgpp_codigo");
            if ($item) {
                $item->delete();
            }

        }catch (Exception $ex){
            throw new Zend_Validate_Exception("Falha ao excluir Participante: " . $ex->getMessage());
        }
    }





}
