<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsProgramasSociais extends Elotech_Db_Table_Abstract {

    protected $_name = 'as_programas_sociais';
    protected $_primary = 'ps_codigo';
    protected $_sequence = 'seq_ps_codigo';

    /**
    * Salva os dados do prontuário
    * @return SQL
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao salvar Programas sociais: ".$ex->getMessage());
        }
    }
    
    /**
    * Retorna os programas sociais em um select
    * @return SQL
    */
    public function selectTagProgramas($psCodigo){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("ps"=>"as_programas_sociais"));
        return parent::selectTag($sql,"ps_nome","ps_codigo",null,true,"ps_codigo","dap_ps_codigo",null,$psCodigo);
    }
    
}
