<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsProntuarioSuas extends Elotech_Db_Table_Abstract {

  protected $_name = 'as_prontuario_suas';
  protected $_primary = 'asps_codigo';
  protected $_sequence = 'seq_asps_codigo';

  /**
   * Verifica se o número de prontuário já existe
   * @return SQL
   */
  public function validaNumProntuario($numProntuario) {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("asps" => "as_prontuario_suas"), array("asps_codigo"))
      ->where("asps_num_prontuario =?", $numProntuario);
    return $this->fetchAll($sql)->count();
  }

  public function validaNumProntuarioHabitacional($numProntuario) {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("asps" => "as_prontuario_suas"), array("asps_codigo"))
      ->where("asps_num_habitacional = ?", $numProntuario);
    return $this->fetchAll($sql)->count();
  }

  /**
   * Salva os dados do prontuário
   * @return SQL
   */
  public function salvar($data) {
    try {
      return parent::salvar($data);
    } catch (Exception $ex) {
      throw new Zend_Validate_Exception(
        "Falha ao carregar o prontuario: " . $ex->getMessage());
    }
  }

  /**
   * Retorna a composição familiar do prontuário SUAS
   * @param int $aspsCodigo
   * @return Zend_Db_Table_Row_Abstract
   */
  public function getDadosComposicaoFamiliarSuas($aspsCodigo = FALSE) {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("asps" => "as_prontuario_suas"), array())
      ->join(array("aspsu" => "as_prontuario_suas_usuario"), "asps.asps_codigo=aspsu.asps_codigo", array("aspsu_codigo", "aspsu_parentesco", "aspsu_num_ordem", "aspsu_ativo"))
      ->join(array("usu" => "usuario"), "aspsu.usu_codigo=usu.usu_codigo", array("usu_nome", "usu_sexo", "usu_datanasc", "usu_asdoc_teprov",
        "usu_asdeficiencia", "usu_cpf", "usu_asdoc_cnprov", "usu_asdoc_rgprov", "usu_asdoc_ctpsprov", "usu_asdoc_cpfprov", "usu_codigo",
        "as_cond_ocupacao", "as_possui_qualificacao", "as_possui_qualificacao", "as_possui_qualificacao_qual", "as_renda_mensal",
        "as_usu_alfabetizado", "as_usu_estuda", "as_usu_escolaridade", "usu_as_aposentado", "usu_as_bpc", "usu_as_tipo_deficiencia", "usu_as_cuidado_constante",
        "usu_as_resp_cuidado", "usu_as_doenca_grava", "usu_as_remedio_controlado", "usu_as_alcoolatra", "usu_as_drogado"))
      ->where("asps.asps_codigo =?", $aspsCodigo)
      ->order("aspsu.aspsu_num_ordem ASC");
    return $this->fetchAll($sql);
  }

  /*
   * Recuperar situação habitacional
   */
  public function getSituacaoHabitacional($aspsCodigo = FALSE) {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("asps" => "as_prontuario_suas"), array("asps_situacao_habitacional"))
      ->where("asps.asps_codigo = ?", $aspsCodigo)
      ->order("asps.asps_codigo DESC")
      ->limit(1);
    return $this->fetchRow($sql);
  }


  /**
   * Retorna a composição familiar do prontuário SUAS
   * @param int $aspsCodigo
   * @return Zend_Db_Table_Row_Abstract
   */
  public function getDadosComposicaoFamiliarHabitacional($aspsCodigo = FALSE) {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("asps" => "as_prontuario_suas"), array())
      ->joinLeft(array("assofa" => "as_aspectos_sociais_familia"), "asps.asps_codigo=assofa.asps_codigo")
      ->joinLeft(array("conmoratu" => "as_condicao_moradia_atual"), "asps.asps_codigo=conmoratu.asps_codigo")
      ->joinLeft(array("asproc" => "as_procedencia"), "asps.asps_codigo=asproc.asps_codigo")
      ->join(array("aspsu" => "as_prontuario_suas_usuario"), "asps.asps_codigo=aspsu.asps_codigo", array("aspsu_codigo", "aspsu_parentesco", "aspsu_num_ordem", "aspsu_ativo"))
      ->join(array("usu" => "usuario"), "aspsu.usu_codigo=usu.usu_codigo", array("usu_nome", "usu_sexo", "usu_datanasc", "usu_asdoc_teprov",
        "usu_asdeficiencia", "usu_cpf", "usu_asdoc_cnprov", "usu_asdoc_rgprov", "usu_asdoc_ctpsprov", "usu_asdoc_cpfprov", "usu_codigo",
        "as_cond_ocupacao", "as_possui_qualificacao", "as_possui_qualificacao", "as_possui_qualificacao_qual", "as_renda_mensal",
        "as_usu_alfabetizado", "as_usu_estuda", "as_usu_escolaridade", "usu_as_aposentado", "usu_as_bpc", "usu_as_tipo_deficiencia", "usu_as_cuidado_constante",
        "usu_as_resp_cuidado", "usu_as_doenca_grava", "usu_as_remedio_controlado", "usu_as_alcoolatra", "usu_as_drogado"))
      ->where("asps.asps_codigo =?", $aspsCodigo)
      ->order("aspsu.aspsu_num_ordem ASC");
    return $this->fetchAll($sql);
  }

  /**
   * Retorna a composição familiar somente com os integrantes ativos
   * @param int $aspsCodigo
   * @return Zend_Db_Table_Row_Abstract
   */
  public function getDadosComposicaoFamiliar($aspsCodigo = FALSE) {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("asps" => "as_prontuario_suas"), array())
      ->join(array("aspsu" => "as_prontuario_suas_usuario"), "asps.asps_codigo=aspsu.asps_codigo", array("aspsu_codigo", "aspsu_parentesco", "aspsu_num_ordem", "aspsu_ativo"))
      ->join(array("usu" => "usuario"), "aspsu.usu_codigo=usu.usu_codigo", array("usu_nome", "usu_sexo", "usu_datanasc", "usu_asdoc_teprov",
        "usu_asdeficiencia", "usu_cpf", "usu_asdoc_cnprov", "usu_asdoc_rgprov", "usu_asdoc_ctpsprov", "usu_asdoc_cpfprov", "usu_codigo",
        "as_cond_ocupacao", "as_possui_qualificacao", "as_possui_qualificacao", "as_possui_qualificacao_qual", "as_renda_mensal",
        "as_usu_alfabetizado", "as_usu_estuda", "as_usu_escolaridade", "usu_as_aposentado", "usu_as_bpc", "usu_as_tipo_deficiencia", "usu_as_cuidado_constante",
        "usu_as_resp_cuidado", "usu_as_doenca_grava", "usu_as_remedio_controlado", "usu_as_alcoolatra", "usu_as_drogado"))
      ->where("asps.asps_codigo =?", $aspsCodigo)
      ->where("aspsu.aspsu_ativo =?", "t")
      ->order("aspsu.aspsu_num_ordem ASC");
    return $this->fetchAll($sql);
  }

  /**
   * Retorna a composição familiar do prontuário SUAS
   * @param int $aspsCodigo
   * @return Zend_Db_Table_Row_Abstract
   */
  public function getDadosComposicaoFamiliarFeminina($aspsCodigo = FALSE) {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("asps" => "as_prontuario_suas"), array())
      ->join(array("aspsu" => "as_prontuario_suas_usuario"), "asps.asps_codigo=aspsu.asps_codigo", array("aspsu_codigo", "aspsu_parentesco", "aspsu_num_ordem", "aspsu_ativo"))
      ->join(array("usu" => "usuario"), "aspsu.usu_codigo=usu.usu_codigo", array("usu_nome", "usu_sexo", "usu_datanasc", "usu_asdoc_teprov",
        "usu_asdeficiencia", "usu_cpf", "usu_asdoc_cnprov", "usu_asdoc_rgprov", "usu_asdoc_ctpsprov", "usu_asdoc_cpfprov", "usu_codigo",
        "as_cond_ocupacao", "as_possui_qualificacao", "as_possui_qualificacao", "as_possui_qualificacao_qual", "as_renda_mensal",
        "as_usu_alfabetizado", "as_usu_estuda", "as_usu_escolaridade", "usu_as_aposentado", "usu_as_bpc", "usu_as_tipo_deficiencia", "usu_as_cuidado_constante",
        "usu_as_resp_cuidado", "usu_as_doenca_grava", "usu_as_remedio_controlado", "usu_as_alcoolatra", "usu_as_drogado"))
      ->where("asps.asps_codigo =?", $aspsCodigo)
      ->where("aspsu.aspsu_ativo =?", "t")
      ->where("usu.usu_sexo = 'F' or usu.usu_sexo = 'f'")
      ->order("aspsu.aspsu_num_ordem ASC");
    return $this->fetchAll($sql);
  }

  /**
   * Retorna a composição familiar do prontuário SUAS
   * @param int $aspsCodigo
   * @return Zend_Db_Table_Row_Abstract
   */
  public function getCodigosComposicaoFamiliar($aspsCodigo = FALSE) {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->distinct()
      ->from(array("asps" => "as_prontuario_suas"), array())
      ->join(array("aspsu" => "as_prontuario_suas_usuario"), "asps.asps_codigo=aspsu.asps_codigo", array())
      ->join(array("usu" => "usuario"), "aspsu.usu_codigo=usu.usu_codigo", array("usu_codigo"))
      ->where("asps.asps_codigo =?", $aspsCodigo);
    return $this->fetchAll($sql);
  }

  /**
   * Retorna dados unidade, usuario e prontuario do cidadão de referência
   * @param int $aspsCodigo , $usuCodigo
   * @return Zend_Db_Table_Row_Abstract
   */
  public function getDadosProntuarioRef($aspsCodigo = FALSE, $usuCodigo = FALSE) {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("asps" => "as_prontuario_suas"), array("asps_num_prontuario", "asps_num_habitacional"))
      ->join(array("aspsuni" => "as_prontuario_suas_unidade"), "asps.asps_codigo=aspsuni.asps_codigo AND aspsuni_dtfinal is null", array("aspsuni_codigo"))
      ->join(array("uni" => "unidade"), "aspsuni.uni_codigo=uni.uni_codigo", array("uni_codigo", "uni_desc"))
      ->join(array("aspsu" => "as_prontuario_suas_usuario"), "asps.asps_codigo=aspsu.asps_codigo", array())
      ->join(array("usu" => "usuario"), "aspsu.usu_codigo=usu.usu_codigo", array("usu_nome", "usu_codigo"))
      ->where("aspsu.usu_codigo =?", $usuCodigo)
      ->where("asps.asps_codigo =?", $aspsCodigo);
    return $this->fetchRow($sql);
  }

  /**
   * Retorna o último número do prontuáro
   * @param int $aspsCodigo
   * @return Zend_Db_Table_Row_Abstract
   */
  public function getUltNumeroProntuario() {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("asps" => "as_prontuario_suas"), array("asps_num_prontuario", "asps_num_habitacional"))
      ->order("asps.asps_num_prontuario DESC")
      ->limit(1);
    return $this->fetchRow($sql);
  }

  public function getUltNumeroProntuarioHabitacional() {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("asps" => "as_prontuario_suas"), array("count(asps_num_habitacional) as asps_num_habitacional"))
      ->where("asps.asps_num_habitacional is not null")
      ->order("asps.asps_num_habitacional DESC")
      ->group("asps.asps_num_habitacional")
      ->limit(1);
    return $this->fetchRow($sql);
  }

  public function getGruposPorProntuarioSuas($aspsCodigo = FALSE) {

    $membros = $this->getDadosComposicaoFamiliarSuas($aspsCodigo);
    $codigos_membros = array();

    foreach ($membros as $membro){
      array_push($codigos_membros, $membro->usu_codigo);
    }
    $usu_codigos = implode(',', $codigos_membros);


    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("asapar" => "as_atendimentocol_participantes"), array("asapar_dtingresso"))
      ->join(array("asag" => "as_atendimentocol_grupo"), "asag.asag_codigo = asapar.asag_codigo", array("asag_titulo", "asag_status"))
      ->join(array("uni" => "unidade"), "asag.uni_codigo=uni.uni_codigo", array("uni_desc"))
      ->join(array("usu" => "usuario"), "asapar.usu_codigo=usu.usu_codigo", array("usu_nome"))
      ->where("asapar.usu_codigo IN ($usu_codigos)")
      ->order("asag.asag_titulo DESC");
    return $this->fetchAll($sql);
  }
}
