<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsProntuarioSuasUnidade extends Elotech_Db_Table_Abstract {

    protected $_name = 'as_prontuario_suas_unidade';
    protected $_primary = 'aspsuni_codigo';
    protected $_sequence = 'seq_aspsuni_codigo';

    /**
    * Salva os dados de vínculo do prontuário com a unidade
    * @return SQL
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao cadastrar vínculo prontuário: ".$ex->getMessage());
        }
    }
    public function getCodigoPeloSuas($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->distinct()
                    ->from(array("aspsuni"=>"as_prontuario_suas_unidade"),array("aspsuni_codigo"))
                    ->where("asps_codigo =?",$aspsCodigo);
        return $this->fetchRow($sql);
    }
    
}
