<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsProntuarioSuasUsuario extends Elotech_Db_Table_Abstract {

    protected $_name = 'as_prontuario_suas_usuario';
    protected $_primary = 'aspsu_codigo';
    protected $_sequence = 'seq_aspsu_codigo';

    /**
    * Salva os dados de vínculo da familia com o prontuário
    * @return SQL
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao cadastrar primeiro atendimento: ".$ex->getMessage());
        }
    }
    
    /**
    * Busca código primário da tabela pelo código do suas
    * @return SQL
    */
    public function getCodigoPeloSuas($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->distinct()
                    ->from(array("aspsu"=>"as_prontuario_suas_usuario"),array("aspsu_codigo"))
                    ->where("asps_codigo =?",$aspsCodigo);
        return $this->fetchRow($sql);
    }
    
    /**
    * Retorna último nº da ordem da composição familiar do prontuário SUAS
    * @param int $aspsCodigo
    * @return Zend_Db_Table_Row_Abstract
    */
    public function getOrdemComposicaoFamiliar($aspsCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspsu"=>"as_prontuario_suas_usuario"),array("aspsu_num_ordem"))
                    ->join(array("usu"=>"usuario"),"aspsu.usu_codigo=usu.usu_codigo",array())
                    ->where("aspsu.asps_codigo =?",$aspsCodigo)
                    ->order("aspsu_num_ordem DESC")
                    ->limit(1);
        return $this->fetchRow($sql);
    }
    
    /**
    * Retorna código do Usuário pelo código
    * @param int $aspsCodigo
    * @return Zend_Db_Table_Row_Abstract
    */
    public function getCodigo($aspsuCodigo){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspsu"=>"as_prontuario_suas_usuario"),array("usu_codigo"))
                    ->join(array("usu"=>"usuario"),"aspsu.usu_codigo=usu.usu_codigo",array())
                    ->where("aspsu.aspsu_codigo =?",$aspsuCodigo);
        return $this->fetchRow($sql);
    }
    
    /**
    * Retorna todas as data de nascimento dos cidadão envolvido naquele SUAS
    * @param int $aspsCodigo
    * @return Zend_Db_Table_Row_Abstract
    */
    public function getDtNascimentoCidadaoSuas($aspsCodigo){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspsu"=>"as_prontuario_suas_usuario"),array())
                    ->join(array("usu"=>"usuario"),"aspsu.usu_codigo=usu.usu_codigo",array("usu_datanasc"))
                    ->where("aspsu.asps_codigo =?",$aspsCodigo)
                    ->where("aspsu.aspsu_ativo =?","t");
        return $this->fetchAll($sql);
    }
    
    /**
    * Retorna todas as data de nascimento dos cidadão envolvido naquele SUAS
    * que não estudam 
    * @param int $aspsCodigo
    * @return Zend_Db_Table_Row_Abstract
    */
    public function getDtNascCidNaoEstudaSuas($aspsCodigo){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspsu"=>"as_prontuario_suas_usuario"),array())
                    ->join(array("usu"=>"usuario"),"aspsu.usu_codigo=usu.usu_codigo",array("usu_datanasc"))
                    ->where("aspsu.asps_codigo =?",$aspsCodigo)
                    ->where("aspsu.aspsu_ativo =?","t")
                    ->where("as_usu_estuda =?","f");    
        return $this->fetchAll($sql);
    }
    
    /**
    * Retorna todas as data de nascimento dos cidadão envolvido naquele SUAS
    * que são Analfabeto
    * @param int $aspsCodigo
    * @return Zend_Db_Table_Row_Abstract
    */
    public function getDtNascCidAnalfabetoSuas($aspsCodigo){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspsu"=>"as_prontuario_suas_usuario"),array())
                    ->join(array("usu"=>"usuario"),"aspsu.usu_codigo=usu.usu_codigo",array("usu_datanasc"))
                    ->where("aspsu.asps_codigo =?",$aspsCodigo)
                    ->where("aspsu.aspsu_ativo =?","t")
                    ->where("as_usu_alfabetizado =?","f");    
        return $this->fetchAll($sql);
    }
    
    public function getDadosPorCidadao($usuCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspsu"=>"as_prontuario_suas_usuario"),array("asps_codigo"))
                    ->join(array("usu"=>"usuario"),"aspsu.usu_codigo=usu.usu_codigo",array())
                    ->where("aspsu.usu_codigo =?",$usuCodigo)
                    ->where("aspsu.aspsu_ativo =?","t");
        return $this->fetchRow($sql);
    }
    
    public function getCodigosCidadaoFamilia($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->distinct()
                    ->from(array("aspsu"=>"as_prontuario_suas_usuario"),array("usu_codigo"))
                    ->join(array("usu"=>"usuario"),"aspsu.usu_codigo=usu.usu_codigo",array())
                    ->where("aspsu.asps_codigo =?",$aspsCodigo)
                    ->where("aspsu.aspsu_ativo =?","t");
        return $this->fetchAll($sql);
    }
    
    public function getSuasUsuario($asps_codigo=FALSE,$usu_codigo=FALSE){
        if(empty($asps_codigo) || empty($usu_codigo))
            return false;

        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from("as_prontuario_suas_usuario")
                    ->where("usu_codigo=$usu_codigo")
                    ->where("asps_codigo=$asps_codigo");
        
        return $this->fetchRow($sql);
    }
    
    
}
