<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsRegistrosViolacao extends Elotech_Db_Table_Abstract {

    protected $_name = 'as_registros_violacao';
    protected $_primary = 'asrv_codigo';
    protected $_sequence = 'seq_asrv_codigo';

    /**
    * Salva os dados de vínculo da familia com o prontuário
    * @return SQL
    */
    public function salvar($data){
        try{
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao cadastrar primeiro atendimento: ".$ex->getMessage());
        }
    }
    
    /**
    * Retorna as situações de violação da família
    * @return SQL
    */
    public function getDadosPeloSuas($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->distinct()
                    ->from(array("asrv"=>"as_registros_violacao"))
                    ->join(array("assv"=>"as_situacoes_violacao"),"asrv.assv_codigo=assv.assv_codigo",array("assv_codigo","assv_nome"))
	                ->join(array("usu"=>"usuario"),"asrv.usu_codigo_ate=usu.usu_codigo",array("usu_codigo","usu_nome"))
                    ->join(array("asps"=>"as_prontuario_suas"),"asrv.asps_codigo=asps.asps_codigo",array())
                    ->where("asrv.asps_codigo =?",$aspsCodigo);
        return $this->fetchAll($sql);
    }
    
    /**
    * Retorna as situações de violação da família
    * @return SQL
    */
    public function getDadosPeloCodigo($asrvCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->distinct()
                    ->from(array("asrv"=>"as_registros_violacao"))
                    ->join(array("assv"=>"as_situacoes_violacao"),"asrv.assv_codigo=assv.assv_codigo",array("assv_codigo","assv_nome"))
	                ->join(array("usu"=>"usuario"),"asrv.usu_codigo_ate=usu.usu_codigo",array("usu_codigo","usu_nome"))
                    ->join(array("asps"=>"as_prontuario_suas"),"asrv.asps_codigo=asps.asps_codigo",array())
                    ->where("asrv.asrv_codigo =?",$asrvCodigo);
        return $this->fetchRow($sql);
    }
}
