<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsReunioes extends Elotech_Db_Table_Abstract
{

    protected $_name = 'as_reunioes';
    protected $_primary = 'asreu_codigo';

    public function getReunioes()
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asreu" => "as_reunioes"))
            ->join(array("uni" => "unidade"),"asreu.uni_codigo = uni.uni_codigo", "uni_desc");
        return $this->fetchAll($sql);
    }

    public function getReuniao($asreu_codigo = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asreu" => "as_reunioes"))
            ->join(array("uni" => "unidade"),"asreu.uni_codigo = uni.uni_codigo", "uni_desc")
            ->where("asreu_codigo = $asreu_codigo");
        return $this->fetchRow($sql);
    }

    public function getReuniaoPesquisa($term)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asreu" => "as_reunioes"))
            ->join(array("uni" => "unidade"),"asreu.uni_codigo = uni.uni_codigo" ,"uni_desc")
            ->where("asreu_titulo ilike '%$term%'");
        return $this->fetchAll($sql);

    }

    public function salvar($data)
    {
        try {
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                "Falha ao salvar Reunião: " . $ex->getMessage());
        }
    }

    public function excluir($asreu_codigo)
    {
        try {

            $item = $this->fetchRow("asreu_codigo = $asreu_codigo");
            if ($item) {
                $item->delete();
            }

        } catch (Exception $ex) {
            throw new Zend_Validate_Exception("Falha ao excluir Reunião: " . $ex->getMessage());
        }
    }

}
