<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsReunioesParticipantes extends Elotech_Db_Table_Abstract
{

    protected $_name = 'as_reunioes_participantes';
    protected $_primary = 'asreupar_codigo';

    public function getParticipantes($asreu_codigo)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asreupar" => "as_reunioes_participantes"))
            ->join(array("usr" => "usuarios"),"asreupar.usr_codigo = usr.usr_codigo", array("usr_codigo", "usr_nome"))
            ->joinLeft(array("crg" => "cargos"),"usr.crg_codigo = crg.crg_codigo AND crg.crg_status IS TRUE", array("crg_nome"))
            ->where("asreu_codigo = $asreu_codigo")
            ->order("usr.usr_nome");

        return $this->fetchAll($sql);
    }

    public function getReuniaoPesquisa($term)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asreu" => "as_reunioes"))
            ->where("asreu_desc ilike '%$term%'");
        return $this->fetchAll($sql);

    }

    public function salvar($data)
    {
        try {
            // Limpando dados em branco
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                "Falha ao salvar Participante: " . $ex->getMessage());
        }
    }

    public function excluir($asreupar_codigo)
    {
        try {

            $item = $this->fetchRow("asreupar_codigo = $asreupar_codigo");
            if ($item) {
                $item->delete();
            }

        } catch (Exception $ex) {
            throw new Zend_Validate_Exception("Falha ao excluir participante: " . $ex->getMessage());
        }
    }

}
