<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AsTipoMedidaSocioeducativa extends Elotech_Db_Table_Abstract {
    
    protected $_name = 'as_tipo_medida_socioeducativa';
    protected $_primary = 'astms_codigo';
    protected $_sequence = 'seq_astms_codigo';
    
    /**
    * Retorna a os tipo de medida socioeducativa em select
    * @return Zend_Db_Table_Row_Abstract
    */
    public function selectTag($astmsCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("astms"=>"as_tipo_medida_socioeducativa"),array("astms_codigo","astms_nome"))
                    ->order("astms.astms_num ASC");
        return parent::selectTag($sql,"astms_nome","astms_codigo",null,true,"astms_codigo","dp_astms_codigo",null,$astmsCodigo);
    }
    
}
