<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspsAnotProgramasCt extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_anot_programas_ct';
    protected $_primary = 'aspsap_codigo';
    protected $_sequence = 'seq_aspsap_codigo';

    /**
    * Salva os dados do prontuário
    * @return SQL
    */
    public function salvar($data){
        try{
            // Limpando dados em branco
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao salvar Anotações do Programa: ".$ex->getMessage());
        }
    }
    
    /**
    * Retorna os dados de anotações dos programas pelo
    * @param int $aspsapCodigo
    * @return Zend_Db_Table_Row_Abstract
    */
    public function getDadosPorId($psCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspsap"=>"asps_anot_programas_ct"))
                    ->join(array("aspsu"=>"as_prontuario_suas_usuario"),"aspsap.usu_codigo=aspsu.usu_codigo",array())
                    ->join(array("ps"=>"as_programas_sociais"),"aspsap.ps_codigo=ps.ps_codigo",array("ps_nome"))
                    ->join(array("usu"=>"usuario"),"aspsu.usu_codigo=usu.usu_codigo",array("usu_nome"))
                    ->where("aspsap.aspsap_codigo =?",$psCodigo);
        return $this->fetchRow($sql);
    }
    
    /**
    * Retorna os dados de anotações dos progranas prontuário SUAS
    * @param int $aspsapCodigo
    * @return Zend_Db_Table_Row_Abstract
    */
    public function getDadosPorProntuario($aspsCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspsap"=>"asps_anot_programas_ct"))
                    ->join(array("aspsu"=>"as_prontuario_suas_usuario"),"aspsap.usu_codigo=aspsu.usu_codigo",array())
                    ->join(array("ps"=>"as_programas_sociais"),"aspsap.ps_codigo=ps.ps_codigo",array("ps_nome"))
                    ->join(array("usu"=>"usuario"),"aspsu.usu_codigo=usu.usu_codigo",array("usu_nome"))
                    ->where("aspsu.asps_codigo =?",$aspsCodigo)
                    ->order("aspsap.aspsap_codigo DESC");
        return $this->fetchAll($sql);
    }
    
    /**
    * Retorna dados unidade, usuario e prontuario do cidadão de referência
    * @param int $aspsCodigo, $usuCodigo
    * @return Zend_Db_Table_Row_Abstract
    */
    /*public function getDadosProntuarioRef($aspsCodigo=FALSE,$usuCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("asps"=>"as_prontuario_suas"),array("asps_num_prontuario"))
                    ->join(array("uni"=>"unidade"),"asps.uni_codigo=uni.uni_codigo",array("uni_codigo","uni_desc"))
                    ->join(array("aspsu"=>"as_prontuario_suas_usuario"),"asps.asps_codigo=aspsu.asps_codigo",array())
                    ->join(array("usu"=>"usuario"),"aspsu.usu_codigo=usu.usu_codigo",array("usu_nome","usu_codigo"))
                    ->where("aspsu.usu_codigo =?",$usuCodigo)
                    ->where("asps.asps_codigo =?",$aspsCodigo);
        return $this->fetchRow($sql);
    }*/
        
    /**
    * Retorna o último número do prontuáro
    * @param int $aspsCodigo
    * @return Zend_Db_Table_Row_Abstract
    */
    /*public function getUltNumeroProntuario() {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("asps"=>"as_prontuario_suas"),array("asps_num_prontuario"))
                    ->order("asps.asps_num_prontuario DESC")
                    ->limit(1);
        return $this->fetchRow($sql);
    }*/
}
