<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspsAnotProgramasfamCt extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_anot_programasfam_ct';
    protected $_primary = 'aspsapf_codigo';
    protected $_sequence = 'seq_aspsapf_codigo';

    /**
    * Salva os dados do prontuário
    * @return SQL
    */
    public function salvar($data){
        try{
            // Limpando dados em branco
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao salvar Anotações do Programa: ".$ex->getMessage());
        }
    }
    
    /**
    * Retorna os dados de anotações dos programas pelo
    * @param int $aspsapCodigo
    * @return Zend_Db_Table_Row_Abstract
    */
    public function getDadosPorId($aspsapfCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspsapf"=>"asps_anot_programasfam_ct"))
                    ->join(array("asps"=>"as_prontuario_suas"),"aspsapf.asps_codigo=asps.asps_codigo",array())
                    ->join(array("ps"=>"as_programas_sociais"),"aspsapf.ps_codigo=ps.ps_codigo",array("ps_nome"))
                    ->where("aspsapf.aspsapf_codigo =?",$aspsapfCodigo);
        return $this->fetchRow($sql);
    }
    
    /**
    * Retorna os dados de anotações dos progranas prontuário SUAS
    * @param int $aspsapCodigo
    * @return Zend_Db_Table_Row_Abstract
    */
    public function getDadosPorProntuario($aspsCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspsapf"=>"asps_anot_programasfam_ct"))
                    ->join(array("asps"=>"as_prontuario_suas"),"aspsapf.asps_codigo=asps.asps_codigo",array())
                    ->join(array("ps"=>"as_programas_sociais"),"aspsapf.ps_codigo=ps.ps_codigo",array("ps_nome"))
                    ->where("aspsapf.asps_codigo =?",$aspsCodigo)
                    ->order("aspsapf.aspsapf_codigo DESC");
        return $this->fetchAll($sql);
    }
    
    /**
    * Retorna quanto a familia recebe de programas sociais
    * @param int $aspsCodigo
    * @return Zend_Db_Table_Row_Abstract
    */
    public function getDadosRendaProgs($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspsapf"=>"asps_anot_programasfam_ct"),array("COALESCE(SUM(aspsapf_vlr_recebido),NULL,0) AS renda_progs"))
                    ->where("aspsapf.aspsapf_dtfinal IS NULL")
                    ->where("aspsapf.asps_codigo =?",$aspsCodigo);
        return $this->fetchRow($sql);
    }
        
    /**
    * Retorna o último número do prontuáro
    * @param int $aspsCodigo
    * @return Zend_Db_Table_Row_Abstract
    */
    /*public function getUltNumeroProntuario() {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("asps"=>"as_prontuario_suas"),array("asps_num_prontuario"))
                    ->order("asps.asps_num_prontuario DESC")
                    ->limit(1);
        return $this->fetchRow($sql);
    }*/
}
