<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspsAnotSaudeCs extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_anot_saude_cs';
    protected $_primary = 'aspsas_codigo';
    protected $_sequence = 'seq_aspsas_codigo';

    /**
    * Salva anotações de saúde e retorna o código
    * @return SQL
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao salvar anotações de saúde: ".$ex->getMessage());
        }
    }
    
    /**
    * Pega os dados de anotação da saúde por prontuário
    * @return SQL
    */
    public function getDadosPorProntuario($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspsas"=>"asps_anot_saude_cs"))
                    ->join(array("asps"=>"as_prontuario_suas"),"aspsas.asps_codigo=asps.asps_codigo",array(""))
                    ->where("aspsas.asps_codigo =?",$aspsCodigo);
        return $this->fetchRow($sql);
    }
 
}
