<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspsCondicoesHabitacionais extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_condicoes_habitacionais';
    protected $_primary = 'aspsch_codigo';
    protected $_sequence = 'seq_aspsch_codigo';

    /**
    * Salva os dados de condições habitacionais
    * @return SQL
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao salvar a condição: ".$ex->getMessage());
        }
    }
    
    /**
    * Pega os dados de condições habitacionais por prontuário
    * @return SQL
    */
    public function getDadosPorProntuario($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspsch"=>"asps_condicoes_habitacionais"))
                    ->join(array("asps"=>"as_prontuario_suas"),"aspsch.asps_codigo=asps.asps_codigo",array())
                    ->where("aspsch.asps_codigo =?",$aspsCodigo);
        return $this->fetchRow($sql);
    }
    
}
