<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspsConvivenciaFamiliar extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_convivencia_familiar';
    protected $_primary = 'aspscf_codigo';
    protected $_sequence = 'seq_aspscf_codigo';

    /**
    * Salva os dados de convivência familiar e comunitária e retorna o código
    * @return SQL
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao cadastrar convivência: ".$ex->getMessage());
        }
    }
    
    /**
    * Pega os dados da convivência por prontuário
    * @return SQL
    */
    public function getDadosPorProntuario($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspscf"=>"asps_convivencia_familiar"))
                    ->join(array("asps"=>"as_prontuario_suas"),"aspscf.asps_codigo=asps.asps_codigo",array(""))
                    ->where("aspscf.asps_codigo =?",$aspsCodigo);
        return $this->fetchRow($sql);
    }
 
}
