<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspsHistAcolhimento extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_hist_acolhimento';
    protected $_primary = 'aspsha_codigo';
    protected $_sequence = 'seq_aspsha_codigo';

    /**
    * Salva os dados de histórico de acolhimento
    * @return SQL
    */
    public function salvar($data){
        try{
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao cadastrar Histórico: ".$ex->getMessage());
        }
    }
    
    /**
    * Retorna as situações de violação da família
    * @return SQL
    */
    public function getDadosPeloSuas($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->distinct()
                    ->from(array("aspsha"=>"asps_hist_acolhimento"))
                    ->join(array("asps"=>"as_prontuario_suas"),"aspsha.asps_codigo=asps.asps_codigo",array())
                    ->join(array("usu"=>"usuario"),"aspsha.usu_codigo=usu.usu_codigo",array("usu_codigo","usu_nome"))
                    ->join(array("aspsu"=>"as_prontuario_suas_usuario"),"usu.usu_codigo=aspsu.usu_codigo",array("aspsu_num_ordem"))
                    ->where("aspsha.asps_codigo =?",$aspsCodigo);
        return $this->fetchAll($sql);
    }
    
    /**
    * Retorna as situações de violação da família
    * @return SQL
    */
    public function getDadosPeloCodigo($aspshaCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->distinct()
                    ->from(array("aspsha"=>"asps_hist_acolhimento"))
                    ->join(array("asps"=>"as_prontuario_suas"),"aspsha.asps_codigo=asps.asps_codigo",array())
                    ->join(array("usu"=>"usuario"),"aspsha.usu_codigo=usu.usu_codigo",array("usu_codigo","usu_nome"))
                    ->join(array("aspsu"=>"as_prontuario_suas_usuario"),"usu.usu_codigo=aspsu.usu_codigo",array("aspsu_num_ordem"))
                    ->where("aspsha.aspsha_codigo =?",$aspshaCodigo);
        return $this->fetchRow($sql);
    }
}
