<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspsMedidasSocioeducativas extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_medidas_socioeducativas';
    protected $_primary = 'aspsms_codigo';
    protected $_sequence = 'seq_aspsms_codigo';

    /**
    * Salva os dados de Medida Socioeducativa
    * @return SQL
    */
    public function salvar($data){
        try{
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao cadastrar Medida: ".$ex->getMessage());
        }
    }

    /**
    * Retorna os dados de medidas socioeducativas
    * @return SQL
    */
    public function getDadosPeloSuas($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->distinct()
                    ->from(array("aspsms"=>"asps_medidas_socioeducativas"))
                    ->join(array("asps"=>"as_prontuario_suas"),"aspsms.asps_codigo=asps.asps_codigo",array())
                    ->join(array("usu"=>"usuario"),"aspsms.usu_codigo=usu.usu_codigo",array("usu_codigo","usu_nome"))
                    ->join(array("astms"=>"as_tipo_medida_socioeducativa"),"astms.astms_codigo=aspsms.astms_codigo",array("astms_nome"))
                    ->join(array("aspsu"=>"as_prontuario_suas_usuario"),"usu.usu_codigo=aspsu.usu_codigo",array("aspsu_num_ordem"))
                    ->where("aspsms.asps_codigo =?",$aspsCodigo);
//                    die($sql);
        return $this->fetchAll($sql);
    }


    /**
    * Retorna os dados de medidas socioeducativas pelo seu ID
    * @return SQL
    */
    public function getDadosPeloCodigo($aspsmsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->distinct()
                    ->from(array("aspsms"=>"asps_medidas_socioeducativas"))
                    ->join(array("asps"=>"as_prontuario_suas"),"aspsms.asps_codigo=asps.asps_codigo",array())
                    ->join(array("usu"=>"usuario"),"aspsms.usu_codigo=usu.usu_codigo",array("usu_codigo","usu_nome"))
                    ->join(array("astms"=>"as_tipo_medida_socioeducativa"),"aspsms.astms_codigo=astms.astms_codigo",array("astms_codigo","astms_nome"))
                    ->join(array("aspsu"=>"as_prontuario_suas_usuario"),"usu.usu_codigo=aspsu.usu_codigo",array("aspsu_num_ordem"))
                    ->where("aspsms.aspsms_codigo =?",$aspsmsCodigo);
        return $this->fetchRow($sql);
    }

}
