<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspsObsCc extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_obs_cc';
    protected $_primary = 'aspscco_codigo';
    protected $_sequence = 'seq_aspscco_codigo';

    /**
    * Salva os dados de observação das condições de convivência familiar
    * @return SQL
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao salvar a observação: ".$ex->getMessage());
        }
    }
    
    /**
    * Pega as observações de convivência familiar
    * @return SQL
    */
    public function getObsSuas($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspscco"=>"asps_obs_cc"),array("aspscco_obs","aspscco_data"))
                    ->join(array("asps"=>"as_prontuario_suas"),"aspscco.asps_codigo=asps.asps_codigo",array())
                    ->join(array("usr"=>"usuarios"),"aspscco.usr_codigo=usr.usr_codigo",array("usr_codigo","usr_nome"))
                    ->where("aspscco.asps_codigo =?",$aspsCodigo);
        return $this->fetchAll($sql);
    }
    
}
