<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspsObsCe extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_obs_ce';
    protected $_primary = 'aspsceo_codigo';
    protected $_sequence = 'seq_aspsceo_codigo';

    /**
    * Salva os dados de observação das condições educacionais
    * @return SQL
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao salvar a observação: ".$ex->getMessage());
        }
    }
    
    /**
    * Pega as observações do prontuário
    * @return SQL
    */
    public function getObsSuas($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspsceo"=>"asps_obs_ce"),array("aspsceo_obs","aspsceo_data"))
                    ->join(array("asps"=>"as_prontuario_suas"),"aspsceo.asps_codigo=asps.asps_codigo",array())
                    ->join(array("usr"=>"usuarios"),"aspsceo.usr_codigo=usr.usr_codigo",array("usr_codigo","usr_nome"))
                    ->where("aspsceo.asps_codigo =?",$aspsCodigo);
        return $this->fetchAll($sql);
    }
    
}
