<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspsObsCf extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_obs_cf';
    protected $_primary = 'aspso_codigo';
    protected $_sequence = 'seq_aspso_codigo';

    /**
    * Salva os dados de observação da composição familiar
    * @return SQL
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao salvar a observação: ".$ex->getMessage());
        }
    }
    
    /**
    * Pega as observações do prontuário
    * @return SQL
    */
    public function getObsSuas($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspso"=>"asps_obs_cf"),array("aspso_obs","aspso_data"))
                    ->join(array("asps"=>"as_prontuario_suas"),"aspso.asps_codigo=asps.asps_codigo",array())
                    ->join(array("usr"=>"usuarios"),"aspso.usr_codigo=usr.usr_codigo",array("usr_codigo","usr_nome"))
                    ->where("aspso.asps_codigo =?",$aspsCodigo);
        return $this->fetchAll($sql);
    }
    
}
