<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspsObsCh extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_obs_ch';
    protected $_primary = 'aspscho_codigo';
    protected $_sequence = 'seq_aspscho_codigo';

    /**
    * Salva os dados de observação da condição habitacional
    * @return SQL
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao salvar a observação: ".$ex->getMessage());
        }
    }
    
    /**
    * Pega as observações do prontuário
    * @return SQL
    */
    public function getObsSuas($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspscho"=>"asps_obs_ch"),array("aspscho_obs","aspscho_data"))
                    ->join(array("asps"=>"as_prontuario_suas"),"aspscho.asps_codigo=asps.asps_codigo",array())
                    ->join(array("usr"=>"usuarios"),"aspscho.usr_codigo=usr.usr_codigo",array("usr_codigo","usr_nome"))
                    ->where("aspscho.asps_codigo =?",$aspsCodigo);
        return $this->fetchAll($sql);
    }
    
}
