<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspsObsCs extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_obs_cs';
    protected $_primary = 'aspscso_codigo';
    protected $_sequence = 'seq_aspscso_codigo';

    /**
    * Salva os dados de observação das condições de saúde
    * @return SQL
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao salvar a observação: ".$ex->getMessage());
        }
    }
    
    /**
    * Pega as observações do prontuário
    * @return SQL
    */
    public function getObsSuas($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspscso"=>"asps_obs_cs"),array("aspscso_obs","aspscso_data"))
                    ->join(array("asps"=>"as_prontuario_suas"),"aspscso.asps_codigo=asps.asps_codigo",array())
                    ->join(array("usr"=>"usuarios"),"aspscso.usr_codigo=usr.usr_codigo",array("usr_codigo","usr_nome"))
                    ->where("aspscso.asps_codigo =?",$aspsCodigo);
        return $this->fetchAll($sql);
    }
    
}
