<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspsObsCt extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_obs_ct';
    protected $_primary = 'aspscto_codigo';
    protected $_sequence = 'seq_aspscto_codigo';

    /**
    * Salva os dados de observação das condições de trabalho
    * @return SQL
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao salvar a observação: ".$ex->getMessage());
        }
    }
    
    /**
    * Pega as observações do prontuário
    * @return SQL
    */
    public function getObsSuas($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspscto"=>"asps_obs_ct"),array("aspscto_obs","aspscto_data"))
                    ->join(array("asps"=>"as_prontuario_suas"),"aspscto.asps_codigo=asps.asps_codigo",array())
                    ->join(array("usr"=>"usuarios"),"aspscto.usr_codigo=usr.usr_codigo",array("usr_codigo","usr_nome"))
                    ->where("aspscto.asps_codigo =?",$aspsCodigo);
        return $this->fetchAll($sql);
    }
    
}
