<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspsObsMs extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_obs_ms';
    protected $_primary = 'aspsmso_codigo';
    protected $_sequence = 'seq_aspsmso_codigo';

    /**
    * Salva os dados de observação da situação de histórico de medidas
    * @return SQL
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao salvar a observação: ".$ex->getMessage());
        }
    }
    
    /**
    * Pega as observações de histórico de medidas
    * @return SQL
    */
    public function getObsSuas($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspsmso"=>"asps_obs_ms"),array("aspsmso_codigo","aspsmso_obs","aspsmso_data"))
                    ->join(array("asps"=>"as_prontuario_suas"),"aspsmso.asps_codigo=asps.asps_codigo",array())
                    ->join(array("usr"=>"usuarios"),"aspsmso.usr_codigo=usr.usr_codigo",array("usr_codigo","usr_nome"))
                    ->where("aspsmso.asps_codigo =?",$aspsCodigo);
        return $this->fetchAll($sql);
    }
    
}
