<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspsPrimeiroAtendimento extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_primeiro_atendimento';
    protected $_primary = 'aspt_codigo';
    protected $_sequence = 'seq_aspt_codigo';

    /**
    * Verifica se o primeiro atendimento já foi realizado
    * @return SQL
    */
    public function verificaStatusAtendimento($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspt"=>"asps_primeiro_atendimento"),array("aspt_codigo"))
                    ->join(array("aspsu"=>"as_prontuario_suas_usuario"),"aspt.asps_codigo=aspsu.asps_codigo",array())
                    ->join(array("asps"=>"as_prontuario_suas"),"aspsu.asps_codigo=asps.asps_codigo",array())
                    ->where("aspt.asps_codigo =?",$aspsCodigo);
        return $this->fetchAll($sql)->count();
    }
    
    /**
    * Salva o primeiro atendimento e retorna o código
    * @return SQL
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao cadastrar primeiro atendimento: ".$ex->getMessage());
        }
    }
    
    /**
    * Pega os dados do primeiro atendimento por prontuário
    * @return SQL
    */
    public function getDadosPorProntuario($aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspt"=>"asps_primeiro_atendimento"))
                    ->join(array("asps"=>"as_prontuario_suas"),"aspt.asps_codigo=asps.asps_codigo",array(""))
                    ->where("aspt.asps_codigo =?",$aspsCodigo);
        return $this->fetchRow($sql);
    }
 
}
