<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspsRegGestanteCs extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_reg_gestante_cs';
    protected $_primary = 'aspsrg_codigo';
    protected $_sequence = 'seq_aspsrg_codigo';

    /**
    * Salva os dados de registro de gestante
    * @return SQL
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao salvar Descumprimento Prog.: ".$ex->getMessage());
        }
    }
    
    /**
    * Pega os dados de registro de gestante
    * @return SQL
    */
    public function getDadosPeloCodigo($aspsCodigo){
       $sql = $this->select(FALSE)
                   ->setIntegrityCheck(FALSE)
                   ->distinct()
                   ->from(array("aspsrg"=>"asps_reg_gestante_cs"))
                   ->join(array("usu"=>"usuario"),"aspsrg.usu_codigo=usu.usu_codigo",array("usu_nome"))
                   ->join(array("aspsu"=>"as_prontuario_suas_usuario"),"usu.usu_codigo=aspsu.usu_codigo",array("aspsu_num_ordem"))
                   ->join(array("asps"=>"as_prontuario_suas"),"aspsu.asps_codigo=asps.asps_codigo",array())
                   ->where("aspsrg.asps_codigo =?",$aspsCodigo);
        return $this->fetchAll($sql);
    }
}
