<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspsRegistroSimplificado extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_registro_simplificado';
    protected $_primary = 'aspsrs_codigo';
    protected $_sequence = 'seq_aspsrs_codigo';

    /**
    * Salva o primeiro atendimento e retorna o código
    * @return SQL
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao salvar registro simplificado: ".$ex->getMessage());
        }
    }
    
    public function getIdParametros($dadosEncCid=FALSE,$aspsCodigo=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("aspsrs"=>"asps_registro_simplificado"),array("aspsrs_codigo"))
                    ->where("aspsrs.asps_codigo =?",$aspsCodigo)
                    ->where("aspsrs.usr_codigo =?",$dadosEncCid->usr_codigo)
                    ->where("aspsrs.usu_codigo =?",$dadosEncCid->usu_codigo)
                    ->where("aspsrs.aspsrs_data_atendimento =?",$dadosEncCid->asae_dtinicio)
                    ->where("aspsrs_codigo_desc =?",($dadosEncCid->asap_num == 5 ? "2" : "1"));
        return $this->fetchRow($sql);
    }
    
    public function excluir($aspsrsCodigo=FALSE) {
        $item = $this->fetchRow("aspsrs_codigo=$aspsrsCodigo");
        if ($item) {
            $item->delete();
        }
    }
 
}
