<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AspseEspecSociaisCf extends Elotech_Db_Table_Abstract {

    protected $_name = 'asps_espec_sociais_cf';
    protected $_primary = 'aspses_codigo';
    protected $_sequence = 'seq_aspses_codigo';

    /**
    * Salva os dados de observação da composição familiar
    * @return SQL
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                    "Falha ao salvar a Especificidade: ".$ex->getMessage());
        }
    }
    
    /**
    * Pega os dados de especificidades sociais pelo código
    * @return SQL
    */
    public function getDadosPeloCodigo($aspsCodigo){
       $sql = $this->select(FALSE)
                   ->setIntegrityCheck(FALSE)
                   ->from(array("aspses"=>"asps_espec_sociais_cf"))
                   ->join(array("asps"=>"as_prontuario_suas"),"aspses.asps_codigo=asps.asps_codigo",array())
                   ->where("aspses.asps_codigo =?",$aspsCodigo);
       return $this->fetchRow($sql);
    }
}
