<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_AtendimentoSocial extends Elotech_Db_Table_Abstract {

	protected $_name = 'atendimento_social';
	protected $_primary = 'ats_codigo';

        public function salvar(array $data) {	
            return parent::salvar($data);
	}
	
	/**
	 * Sempre retorna um atendimento. Se não existir o método irá criar.
	 * @return Zend_Db_Table_Row_Abstract 
	 */
	public function getAtendimentoAtual($age_codigo=FALSE){
            if($age_codigo){
                return $this->fetchRow("age_codigo=$age_codigo");
            }
        }
        
        public function getTiposDeFichasPorUsuario($usuCodigo){
            $sql  = $this->select(FALSE)
                        ->distinct()
                        ->setIntegrityCheck(FALSE)
                        ->from(array("age"=>"agendamento"),array("tpf_codigo"))
                        ->where("usu_codigo =?",$usuCodigo)
                        ->where("tpf_codigo IS NOT NULL");
            return $this->fetchAll($sql);
        }
        
        public function historicoFichasAtendidas(){
            
        }
        
        public function getDadosAtendimentoGeral($ateCodigo){
            $sql = $this->select(FALSE)
                        ->setIntegrityCheck(FALSE)
                        ->from(array("ats"=>"atendimento_social"),array("ats_codigo","ats_descricao"))
                        ->join(array("age"=>"agendamento"), "age.age_codigo=ats.age_codigo", array("age_atendido","age_data"))
			->join(array("u"=>"usuario"),"u.usu_codigo=age.usu_codigo", array("usu_codigo","usu_fone","usu_cartao_sus","usu_nome","usu_sexo","usu_mae","usu_ocupacao","usu_datanasc"))
                        ->join(array("uni"=>"unidade"), "uni.uni_codigo=age.uni_codigo", "uni_desc")
                        ->join(array("usr"=>"usuarios"),"usr.usr_codigo=age.med_codigo", array("usr_codigo", "usr_nome", "usr_num_conselho"))
                        ->join(array("e"=>"especialidade"),"e.esp_codigo=age.esp_codigo","esp_nome")
                        ->where("ats.ats_codigo =?",$ateCodigo);
            //die($sql);
            return $this->fetchRow($sql);
        }
        

}
