<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Bairro extends Elotech_Db_Table_Abstract {

    protected $_name = 'bairro';
    protected $_primary = 'bai_codigo';
    protected $_sequence = 'bairro_bai_codigo_seq';
    
    /**
    * Verifica se o número de prontuário já existe
    * @return Código Bairro
    */
    public function salvar($data){
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception("Falha ao salvar bairro: ".
                    $ex->getMessage());
        }
    }
    

    /**
    * Verifica se o número de prontuário já existe
    * @return SQL
    */
    public function buscaDados($term){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("bai"=>"bairro"),array("bai_codigo","bai_nome"))
                    ->join(array("cid"=>"cidade"),"bai.cid_codigo=cid.cid_codigo",array("cid_codigo","cid_nome"))
                    ->join(array("est"=>"estado"),"cid.uf_codigo=est.uf_codigo",array("uf_codigo","uf_nome"))
                    ->where("bai_nome ILIKE '%$term%'")
                    ->order("bai_codigo DESC");
        return $this->fetchAll($sql);
    }
    
    /**
    * Pega o código do bairro pelo nome
    * @return SQL
    */
    public function getCodigoPeloNome($bairro=FALSE){
        $sql = $this->select(FALSE)
                      ->setIntegrityCheck(FALSE)
                      ->from(array("bai"=>"bairro"),array("bai_codigo"))
                      ->where("retira_acentos(UPPER(bai_nome)) = retira_acentos(UPPER('$bairro'))")
                      ->order("bai_codigo DESC")
                      ->limit(1);        
        return $this->fetchRow($sql);
    }

    public function getBairros(){
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("bai"=>"bairro"))
            ->joinLeft(array("cid"=>"cidade"),"cid.cid_codigo=bai.cid_codigo",array("cid_nome"))
            ->joinLeft(array("dis"=>"distrito"),"dis.dis_codigo=bai.dis_codigo","dis_nome")
            ->joinLeft(array("cid2"=>"cidade"),"cid2.cid_codigo=dis.cid_codigo",array("cid_distrito"=>"cid_nome"))
            ->order("bai_codigo DESC")
            ->limit(500);
        return $this->fetchAll($where);
    }

    public function getBairro($bai_codigo){
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("bai"=>"bairro"))
            ->joinLeft(array("cid"=>"cidade"),"cid.cid_codigo=bai.cid_codigo",array("cid_nome"))
            ->joinLeft(array("dis"=>"distrito"),"dis.dis_codigo=bai.dis_codigo","dis_nome")
            ->joinLeft(array("cid2"=>"cidade"),"cid2.cid_codigo=dis.cid_codigo",array("cid_distrito"=>"cid_nome","cid_codigo_distrito"=>"cid_codigo"))
            ->where("bai_codigo=$bai_codigo")
            ->order("bai_codigo DESC");
//        die($where);
        return $this->fetchRow($where);
    }

    public function getBairroGeral($bai_codigo){
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("bai"=>"bairro"))
            ->joinLeft(array("cid"=>"cidade"),"cid.cid_codigo=bai.cid_codigo",array("cid_nome"))
            ->joinLeft(array("dis"=>"distrito"),"dis.dis_codigo=bai.dis_codigo","dis_nome")
            ->joinLeft(array("cid2"=>"cidade"),"cid2.cid_codigo=dis.cid_codigo",array("cid_distrito"=>"cid_nome","cid_codigo_distrito"=>"cid_codigo"))
            ->where("bai_codigo=$bai_codigo")
            ->order("bai_codigo DESC");

        $row = $this->fetchRow($where);

        return array(
            "id" => $row->bai_codigo,
            "label" => trim($row->bai_nome),
            "data" => array(
                "bai_codigo" => $row->bai_codigo,
                "bai_nome" => $row->bai_nome,
                "localidade" =>
                    ($row->cid_distrito ? $row->cid_distrito : $row->cid_nome )
                    .' - Distrito: '
                    .($row->dis_nome ? $row->dis_nome : 'NÃO POSSUI')
            )
        );
    }

    public function excluir($bai_codigo=FALSE) {
        $item = $this->fetchRow("bai_codigo=$bai_codigo");
        if ($item)
            $item->delete();
        return true;
    }

    public function verificaVinculosRua($bai_codigo = false){
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from("rua","count(*) as qtde")
            ->where("bai_codigo = $bai_codigo");
        return $this->fetchRow($where);
    }

    public function pesquisar($dados=NULL){
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("bai"=>"bairro"))
            ->joinLeft(array("cid"=>"cidade"),"cid.cid_codigo=bai.cid_codigo",array("cid_nome"))
            ->joinLeft(array("dis"=>"distrito"),"dis.dis_codigo=bai.dis_codigo","dis_nome")
            ->joinLeft(array("cid2"=>"cidade"),"cid2.cid_codigo=dis.cid_codigo",array("cid_distrito"=>"cid_nome"))
            ->order("bai_codigo DESC");

        if (is_string($dados)){
            $where->where("bai_nome ilike '%$dados%' or cid.cid_nome ilike '%$dados%' or cid2.cid_nome ilike '%$dados%' or dis_nome ilike '%$dados%' ");
        }

        //die($where);
        return $this->fetchAll($where);
    }

    public function buscar($busca=false,$rua_codigo=FALSE){
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("bai"=>"bairro"),array("bai_codigo","bai_nome"))
            ->joinLeft(array("dis"=>"distrito"),"dis.dis_codigo=bai.dis_codigo","dis_nome")
            ->joinLeft(array("c_dis"=>"cidade"),"c_dis.cid_codigo=dis.cid_codigo",array("cid_nome_dis"=>"cid_nome"))
            ->joinLeft(array("cid"=>"cidade"),"cid.cid_codigo=bai.cid_codigo","cid_nome")
            ->where("bai_nome ilike '%".$busca."%'");

        $all = $this->fetchAll($sql);
        $out = array();


        foreach ($all as $dados) {
            $out [] = array(
                "id" => $dados->bai_codigo,
                "label" => $dados->bai_nome,
                "data" => array(
                    "bai_nome" => $dados->bai_nome,
                    "bai_codigo" => $dados->bai_codigo,
                    "cid_nome" => ($dados->cid_nome ? ($dados->cid_nome) : ($dados->cid_nome_dis == "" || $dados->cid_nome_dis == null ? "Nenhum vinculo de cidade" : $dados->cid_nome_dis)),
                    "dis_nome" => ($dados->dis_nome ? $dados->dis_nome : "Não possui")
                )
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array("categoria" => "Nenhum item encontrado")
            );
        }
        return $out;
    }
}
