<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Beneficios extends Elotech_Db_Table_Abstract {

    protected $_name = 'beneficios';
    protected $_primary = 'cod_ben';
    protected $_sequence = 'beneficios_cod_ben_seq';

    /**
     * Salva os dados do beneficios
     * @return SQL
     */
    public function salvar($data) {
        try {
            // Limpando dados em branco
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
            "Falha ao salvar Beneficio: " . $ex->getMessage());
        }
    }

    /**
     * Retorna os dados dos beneficios
     * @return SQL
     */
    public function getDados() {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("ben" => "beneficios"))
                ->order("ben.situacao ASC")
                ->order("ben.cod_ben DESC");
        return $this->fetchAll($sql);
    }

    /**
     * Retorna os dados do beneficio por código
     * @return SQL
     */
    public function getDadosPorId($codBen = FALSE) {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("ben"=>"beneficios"))
                ->where("ben.cod_ben =?", $codBen);
        return $this->fetchRow($sql);
    }

    /**
     * Exclui os dados do estabelecimento
     * @return SQL
     */
    public function excluir($codBen = FALSE) {
        $item = $this->fetchRow("cod_ben=$codBen");
        if ($item)
            $item->delete();

        return true;
    }
    
    public function buscaGeral($term){
        $sql = $this->select(FALSE)
                    ->distinct()
                    ->setIntegrityCheck(FALSE)
                    ->from(array("ben" => "beneficios"),array("cod_ben","beneficio"))
                    ->where("beneficio ilike '%$term%'")
                    ->where("situacao =?","A")
                    ->order("beneficio ASC");
        return $this->fetchAll($sql);
    }
    
    public function getDadosNome($nome=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("ben"=>"beneficios"),array("cod_ben"))
                    ->where("beneficio=?", $nome);
        return $this->fetchRow($sql);
    }

    public function pesquisa($term, $stat) {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("ben" => "beneficios"));
            if($stat !== 'Todos'){
                $stat = ($stat === 'Ativos' ? 'A' : 'I');
                $sql->where("ben.situacao =?", $stat);
            }
        $sql->where("retira_acentos(beneficio) ilike retira_acentos('%$term%')", "S")
            ->order("ben.situacao ASC")
            ->order("ben.cod_ben DESC");
        return $this->fetchAll($sql);
    }
}
