<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Cargos extends Elotech_Db_Table_Abstract
{
    protected $_name = 'cargos';
    protected $_primary = 'crg_codigo';
    protected $_sequence = 'cargos_crg_codigo_seq';

    public function salvar($data)
    {
        try {
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                "Falha ao salvar Cargo: " . $ex->getMessage());
        }
    }

    public function excluir($crgCodigo = FALSE)
    {
        $item = $this->fetchRow("crg_codigo=$crgCodigo");
        if ($item)
            $item->delete();

        return true;
    }

    public function getDados()
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("crg" => "cargos"))
            ->order("crg.crg_status ASC")
            ->order("crg.crg_codigo DESC");
        return $this->fetchAll($sql);
    }

    public function getDadosPorId($crgCodigo = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("crg" => "cargos"))
            ->where("crg.crg_codigo =?", $crgCodigo);
        return $this->fetchRow($sql);
    }

    public function buscaGeral($term)
    {
        $sql = $this->select(FALSE)
            ->distinct()
            ->setIntegrityCheck(FALSE)
            ->from(array("crg" => "cargos"), array("crg.crg_codigo", "crg.crg_nome", "crg.crg_status"))
            ->where("crg.crg_nome ilike '%$term%'")
            ->where("crg.crg_status =?", true)
            ->order("crg.crg_nome ASC");
        return $this->fetchAll($sql);
    }

    public function selecttag($crgCodigo = false)
    {
        $sql = $this->select(false)
            ->setIntegrityCheck(false)
            ->from(array("crg" => "cargos"), array("crg.crg_codigo", "crg.crg_nome"))
            ->order("crg.crg_nome ASC");
        return parent::selectTag($sql, "crg_nome", "crg_codigo", null, true, "crg_codigo", "dcrg_crg_codigo", null, $crgCodigo);
    }

	public function pesquisa($term, $stat)
	{
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("crg" => "cargos"));
		if ($stat !== 'Todos') {
			$stat = ($stat == 'Ativos' ? 't' : 'f');
			$sql->where("crg.crg_status =?", $stat);
		}
		$sql->where("retira_acentos(crg_nome) ilike retira_acentos('%$term%')", "S")
			->order("crg.crg_status ASC")
			->order("crg.crg_codigo DESC");

		//die($sql);
		return $this->fetchAll($sql);
	}

	public function getCargoPorProfissional($usrCodigo = FALSE)
	{
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("crg" => "cargos"))
			->join(array("usr" => "usuarios"), "usr.crg_codigo = crg.crg_codigo")
			->where("usr.usr_codigo =?", $usrCodigo);
		return $this->fetchRow($sql);
	}

}
