<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_CertidaoLiberatoria extends Elotech_Db_Table_Abstract {

	protected $_name = 'as_certidao_liberatoria';
	protected $_primary = 'ascl_codigo';
	protected $_sequence = 'as_certidao_liberatoria_ascl_codigo_seq';


	/* ------------------------------------------------------
	 * MÉTODOS AÇÃO SOCIAL
	 * ------------------------------------------------------*/

	public function getCertidoes() {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ascl" => "as_certidao_liberatoria"))
			->join(array("uni" => "unidade"), "ascl.uni_codigo = uni.uni_codigo", array("uni_desc"))
			->order("ascl_codigo DESC")
			->limit(7);

		return $this->fetchAll($sql);
	}

	public function getDadosCertidao($ascl_codigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ascl" => "as_certidao_liberatoria"))
			->join(array("uni" => "unidade"), "ascl.uni_codigo = uni.uni_codigo", array("uni_desc"))
			->join(array("usr" => "usuarios"), "ascl.usr_codigo = usr.usr_codigo", array("usr_nome"))
			->joinLeft(array("crg" => "cargos"), "usr.crg_codigo = crg.crg_codigo", array("crg_nome", "crg_codigo"));

		if ($ascl_codigo) {
			$sql->where("ascl_codigo = $ascl_codigo");
		}
		return $this->fetchRow($sql);
	}

	public function getNumeroCertidao() {
		$exercicioAtual = date('Y');

		$checaCertidao = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ascl" => "as_certidao_liberatoria"), array("ascl_numero", "ascl_exercicio"))
			->order("ascl_codigo DESC");
		$existeCertidao = $this->fetchRow($checaCertidao);

		if (!$existeCertidao) {
			$checaParametro = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("config" => "config"), array("conf_valor_int"))
				->where("conf_chave = 'CERTIDAO_LIBERATORIA_NUMERO_INICIAL'");
			$numero = $this->fetchRow($checaParametro)->conf_valor_int;
			$numeroCertidao = $numero . "/" . $exercicioAtual;
		} else {
			if ($existeCertidao->ascl_exercicio == $exercicioAtual) {
				$numero = $existeCertidao->ascl_numero;
				$numeroCertidao = ($numero + 1) . "/" . $exercicioAtual;
			} else {
				$numero = 1;
				$numeroCertidao = $numero . "/" . $exercicioAtual;
			}

		}

		return $numeroCertidao;
	}

	public function getLeiCertidao() {

		$checaParametro = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("config" => "config"), array("conf_valor_string"))
			->where("conf_chave = 'CERTIDAO_LIBERATORIA_LEI'");
		$lei = $this->fetchRow($checaParametro)->conf_valor_string;

		return $lei;
	}

	public function getDecretoCertidao() {

		$checaParametro = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("config" => "config"), array("conf_valor_string"))
			->where("conf_chave = 'CERTIDAO_LIBERATORIA_DECRETO'");
		$decreto = $this->fetchRow($checaParametro)->conf_valor_string;

		return $decreto;
	}


	public function getDadosPesquisa($busca) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ascl" => "as_certidao_liberatoria"))
			->join(array("uni" => "unidade"), "ascl.uni_codigo = uni.uni_codigo", array("uni_desc"))
			->join(array("usr" => "usuarios"), "ascl.usr_codigo = usr.usr_codigo", array("usr_nome"))
			->order("ascl_codigo DESC");

		$sql->where("uni.uni_desc ILIKE '%$busca%'");

		return $this->fetchAll($sql);
	}

}
