<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Convenio extends Elotech_Db_Table_Abstract {

	protected $_name = 'convenio';
	protected $_primary = 'conv_codigo';
        //protected $_schema = 'aise';

	public function salvar(array $data) {
           // echo "<pre>".print_r($data,1);exit;
		if (empty($data['conv_status']))
			$data['conv_status'] = 't';

		if (empty($data['conv_codigo']))
			$this->peloMenosUm(array("med_codigo","uni_codigo"), $data);
		else if (!empty($data['tipo'])) {
			$this->atualizaSabadoDomingo($data);
		}
		
		if(!empty ($data['med_codigo'])){
			if ($this->fetchAll("conv_status = 't' AND med_codigo = ".$data['med_codigo'])->count()){
				throw new Zend_Validate_Exception("Já existe um convênio para o local cadastrado.");			
			}
		}
                if(!empty ($data['uni_codigo'])){
			if ($this->fetchAll("conv_status = 't' AND uni_codigo = ".$data['uni_codigo'])->count()){
				throw new Zend_Validate_Exception("Já existe um convênio para o local cadastrado.");			
			}
		}
//echo "<pre>".print_r($data,1);exit;
		$this->emptyToUnset($data);
		return parent::salvar($data);
	}

	private function atualizaSabadoDomingo(&$data) {
		if ($data['tipo'] == 'sabado') {
			$data['conv_sabado'] = $data['to'];
		} else {
			$data['conv_domingo'] = $data['to'];
		}
		unset($data['to'], $data['tipo']);
	}

	/**
	 * Busca genérica
	 * @param string $term filtro
	 */
	public function buscar($term, $limite=FALSE, $somenteConveniados=TRUE) {
                
		if ($somenteConveniados) {
			$where = $this->buscarConveniado($term);
		} else {
			$where = $this->buscarTodos($term);
		}

		if ($limite)
			$where->limit($limite);

		//die($where->__toString());
		$all = $this->fetchAll($where);

		$out = array();
		foreach ($all as $med) {
			$out [] = array(
				"id" => $med->codigo_convenio,
				"label" => $med->nome_convenio,
				"data" => $med->toArray()
			);
		}

		if (!count($out)) {
			$out [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array("categoria" => "Nenhum item encontrado")
			);
		}

		return $out;
	}

	private function buscarTodos($term) {
		$sql1 = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("med" => "medico"), array("med_codigo as codigo_convenio", "med_nome as nome_convenio", "prestador_servico", "categoria" => "(CASE WHEN prestador_servico='H' THEN 'Hospital' WHEN prestador_servico='L' THEN 'Laboratório' ELSE 'Médico' END)"))
				->where("prestador_servico IN (?)", array(Application_Model_Medico::LABORATORIO, Application_Model_Medico::HOSPITAL))
				->where("med_nome ilike '%$term%'");

		$sql2 = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("uni" => "unidade"), array("uni_codigo as codigo_convenio", "nome_convenio" => "uni_desc", "prestador_servico" => "('U')", "categoria" => "('Unidade')")) // prestador_servico: U
				->where("uni_desc ilike '%$term%'");

		$where = $this->select(FALSE)
						->setIntegrityCheck(FALSE)
						->union(array($sql1, $sql2), Zend_Db_Select::SQL_UNION_ALL)
						->order(array("prestador_servico", "nome_convenio"));
                
               // die($where);
                return $where;
	}

	private function buscarConveniado($term=FALSE, $conv_codigo=FALSE) {
		$sql1 = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("conv" => "convenio"), "conv_codigo")
				->join(array("med" => "medico"), "med.med_codigo=conv.med_codigo", array("med_codigo as codigo_convenio", "med_nome as nome_convenio", "prestador_servico", "categoria" => "(CASE WHEN prestador_servico='H' THEN 'Hospital' WHEN prestador_servico='L' THEN 'Laboratório' ELSE 'Médico' END)"))
				->where("conv_status = 't'");

		if ($term)
			$sql1->where("med_nome ilike '%$term%'");

		if ($conv_codigo)
			$sql1->where("conv_codigo = $conv_codigo");


		$sql2 = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("conv" => "convenio"), "conv_codigo")
				->join(array("uni" => "unidade"), "uni.uni_codigo=conv.uni_codigo", array("uni_codigo as codigo_convenio", "uni_desc as nome_convenio", "prestador_servico" => "('U')", "categoria" => "('Unidade')"))
				->where("conv_status='t'"); // prestador_servico: U
		if ($term)
			$sql2->where("uni_desc ilike '%$term%'");

		if ($conv_codigo)
			$sql2->where("conv_codigo = $conv_codigo");


	//die($sql1.$sql2);
		return $this->select(FALSE)
						->setIntegrityCheck(FALSE)
						->union(array($sql1, $sql2), Zend_Db_Select::SQL_UNION_ALL)
						->order(array("prestador_servico", "nome_convenio"));
	}

	public function buscarPeloConv($conv_codigo) {
		$where = $this->buscarConveniado(FALSE, $conv_codigo);
                
		return $this->fetchRow($where);
	}

	/**
	 * Diz se o convenio atende no sábado e domingo
	 * @author Falci
	 * @param int $conv_codigo
	 * @return stdClass 
	 */
	public function atendeSabadoEDomingo($conv_codigo) {
		$conv = $this->find($conv_codigo)->current();
		
		$retorno = new stdClass();
		$retorno->sabado = $conv->conv_sabado;
		$retorno->domingo = $conv->conv_domingo;

		return $retorno;
	}

	public function pesquisar($dados=FALSE, $limit=FALSE) {
		$sql1 = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("conv" => "convenio"), array("conv_codigo", "conv_sabado", "conv_domingo"))
				->join(array("med" => "medico"), "med.med_codigo=conv.med_codigo", array("med_nome as convenio"))
				->where("conv_status = 't'")
                                ->where("med_nome ilike '%$dados%'");

		$sql2 = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("conv" => "convenio"), array("conv_codigo", "conv_sabado", "conv_domingo"))
				->join(array("uni" => "unidade"), "uni.uni_codigo=conv.uni_codigo", array("uni_desc as convenio"))
				->where("conv_status = 't'")
                                ->where("uni_desc ilike '%$dados%'");

		$where = $this->select(FALSE)
						->setIntegrityCheck(FALSE)
						->union(array($sql1, $sql2), Zend_Db_Select::SQL_UNION_ALL)
						->order(array("convenio"));
		
		if ($limit) {
			$where->limit(15);
		}
              //  die($where);
		return $this->fetchAll($where);
	}

	protected function selectTag($where, $texto, $value=NULL, $first=NULL, $tag=TRUE, $name=NULL, $id=NULL, $foco=FALSE) {
		if (!$value)
			$value = current($this->_primary);

		if (!$name)
			$name = $value;

		if (!$id)
			$id = $name;

		$all = $this->fetchAll($where);
		$out = "";
		if ($tag)
			$out = "<select name=\"$name\" id=\"$id\"" . ($foco ? " class=\"focus\"" : "") . ">\n";

		if ($first) {
			if (is_array($first))
				$out .= "\t<option value=\"" . $first[0] . "\">" . $first[1] . "</option>\n";
			else
				$out .= "\t<option value=\"0\">-- Selecione --</option>\n";
		}

		foreach ($all as $option) {
			$out .= "\t<option value=\"" . $option->$value . "\">" . trim($option->$texto) . "</option>\n";
		}

		if ($tag)
			$out .= "</select>\n";

		return $out;
	}

	/**
	 * Exclusão Lógica;
	 * @param type $conv_codigo
	 * @return type 
	 */
	public function excluir($conv_codigo) {
		$item = $this->fetchRow("conv_codigo=$conv_codigo");
		if ($item) {
			$item->conv_status = "F";
			$item->save();
		}
		return true;
	}
        
        public function getUnidadePorConvenio($uni_codigo){
            $sql = $this->select()
                        ->from(array("conv"=>"convenio"))
                        ->setIntegrityCheck(FALSE)
                        ->join(array("uni"=>"unidade"), "uni.uni_codigo=conv.uni_codigo",array("uni_codigo","uni_desc"))
                        ->where("conv.uni_codigo=?",$uni_codigo);
            return $this->fetchRow($sql);
        }

}

