<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Domicilio extends Elotech_Db_Table_Abstract
{

    protected $_name = 'domicilio';
    protected $_primary = 'dom_codigo';
    protected $_sequence = 'seq_dom_codigo';
    protected $_dependentTables = array();

    /*---------------------------------------------------------------
    * MÉTODOS AÇÃO SOCIAL 
    *--------------------------------------------------------------*/

    public function getQtdCodDomicilioDuplicado($dadosDomicilio)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("dom" => "domicilio"), "dom_codigo")
            ->join(array("rua"), "dom.rua_codigo=rua.rua_codigo")
            ->where("dom.rua_codigo =?", $dadosDomicilio["rua_codigo"]);
            if($dadosDomicilio["dom_numero"]) {
                $sql->where("dom.dom_numero =?", $dadosDomicilio["dom_numero"]);
            }
            if($dadosDomicilio["co_tipo_domicilio"]){
                $sql->where("dom.co_tipo_domicilio =?", $dadosDomicilio["co_tipo_domicilio"]);
            }

//        die($sql);
        return $this->fetchRow($sql);
    }

    public function getQtdCodDomicilioDuplicadoCompl($dadosDomicilio)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("dom" => "domicilio"))
            ->join(array("rua"), "dom.rua_codigo=rua.rua_codigo")
            ->join(array("bai" => "bairro"), "rua.bai_codigo=bai.bai_codigo")
            ->joinLeft(array("usu" => "usuario"), "dom.usu_codigo_responsavel=usu.usu_codigo", array("usu_nome", "usu_codigo"))
            ->where("dom.rua_codigo =".($dadosDomicilio["rua_codigo"] ? $dadosDomicilio["rua_codigo"] : null));
            if ($dadosDomicilio["dom_numero"] || $dadosDomicilio["dom_numero"] == '0') {
                $sql->where("dom.dom_numero =".$dadosDomicilio["dom_numero"]);
            }
            if($dadosDomicilio["dom_complemento"]){
                $sql->where("dom.dom_complemento = ?", $dadosDomicilio["dom_complemento"]);
            }else {
                $sql->where("dom_complemento is null");
            }
            $sql->limit(1);
        return $this->fetchRow($sql);
    }

    public function salvarDomicilio($dadosDomicilio)
    {
        try {
            return parent::salvar($dadosDomicilio);
        } catch (Exception $exc) {
            throw new Zend_Validate_Exception("Falha ao cadastrar domicilio: " . $exc->getMessage());
        }
    }

    /*---------------------------------------------------------------
    * FIM MÉTODOS AÇÃO SOCIAL 
    *--------------------------------------------------------------*/

    public function salvar(array $data)
    {
        throw new Zend_Validate_Exception("Este método ainda não possui validações domicilio", 1000);
        return parent::salvar($data);
    }

    public function buscarNumerosDeDomicilioPorEndereco($rua_nome, $rua_cep, $rua_bairro, $term)
    {
        if ($term)
            $where = $this->select(FALSE)
                ->distinct()
                ->from(array("dom" => "domicilio"), array("dom_numero"))
                ->join(array("rua"), "dom.rua_codigo=rua.rua_codigo", array(""))
                ->where("rua_nome =?", $rua_nome)
                ->where("rua_cep =?", $rua_cep)
                ->where("rua_bairro =?", $rua_bairro)
                ->where("dom_numero::TEXT ILIKE ('%$term%')")
                ->order(array("dom_numero"))
                ->limit(0);
        $all = $this->fetchAll($where);
        $out = array();
        foreach ($all as $item) {
            $out [] = array(
                "id" => $item->dom_numero,
                "label" => trim($item->dom_numero),
                "data" => array("dom_numero" => $item->dom_numero)
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array("dom_numero" => "")
            );
        }
        return $out;
    }

    public function buscarDomicilioPorEndereco($dados)
    {

        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->distinct()
            ->from(array("dom" => "domicilio"), array("dom_numero", "dom_codigo", "dom_complemento", "dom_telefone"))
            ->join(array("rua"), "dom.rua_codigo=rua.rua_codigo", array("rua_nome", "rua_cep", "rua_codigo", "co_tipo_logradouro"))
            ->joinLeft(array("bai" => "bairro"), "rua.bai_codigo=bai.bai_codigo", array("rua_bairro" => "bai_nome", "bai_codigo"))
            ->joinLeft(array("tp_log" => "tb_ms_tipo_logradouro"), "tp_log.co_tipo_logradouro=rua.co_tipo_logradouro")
            ->joinLeft(array("usu" => "usuario"), "dom.usu_codigo_responsavel=usu.usu_codigo", array("usu_nome", "usu_codigo"))
            ->joinLeft(array("dis" => "distrito"), "dis.dis_codigo=bai.dis_codigo", "dis_nome")
            ->joinLeft(array("c_dis" => "cidade"), "c_dis.cid_codigo=dis.cid_codigo", array("cid_nome_dis" => "cid_nome", "cid_codigo_dis" => "cid_codigo"))
            ->joinLeft(array("cid" => "cidade"), "cid.cid_codigo=bai.cid_codigo", array("cid_nome", "cid_codigo"))
            ->order(array("dom_numero", "rua_nome", "rua_bairro"))
            ->limit(0);

        if ($dados["rua_codigo"]) {
            $where->where("rua.rua_codigo = " . $dados["rua_codigo"]);
        }

        if (empty($dados["rua_codigo"]) && $dados["rua_nome"]) {
            $where->where("rua.rua_nome ilike '%" . $dados["rua_nome"] . "%'");
        }

        if ($dados["rua_cep"]) {
            $where->where("rua.rua_cep = '" . $dados["rua_cep"] . "' ");
        }

        if ($dados["rua_bairro"]) {
            $where->where("bai.bai_nome ilike '%" . $dados["rua_bairro"] . "%'");
        }
        if ($dados["dom_numero"] || $dados["dom_numero"] == '0') {
            $where->where("dom.dom_numero = " . $dados["dom_numero"]);
        }

        if ($dados["dom_complemento"]) {
            $where->where("dom.dom_complemento ilike '%" . $dados["dom_complemento"] . "%'");
        }
//        die($where);
        return $this->fetchAll($where);
    }

    public function pesquisaDomicilioPorCodigo($dom_codigo)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->distinct()
            ->from(array("dom" => "domicilio"),
                array("dom_numero", "dom_codigo", "dom_complemento", "dom_telefone", "dom_ponto_referencia", "dom_as_localizacao", "dom_as_abrigo")
            )
            ->join(array("rua"), "dom.rua_codigo=rua.rua_codigo",
                array("(ds_tipo_logradouro ||' '||rua.rua_nome) as rua_nome", "rua_cep")
            )
            ->joinLeft(array("bai" => "bairro"), "rua.bai_codigo=bai.bai_codigo", array("rua_bairro" => "bai_nome", "bai_codigo"))
            ->joinLeft(array("tp_log" => "tb_ms_tipo_logradouro"), "tp_log.co_tipo_logradouro=rua.co_tipo_logradouro")
            ->joinLeft(array("usu" => "usuario"), "dom.usu_codigo_responsavel=usu.usu_codigo", array("usu_nome", "usu_codigo"))
            ->joinLeft(array("dis" => "distrito"), "dis.dis_codigo=bai.dis_codigo", "dis_nome")
            ->joinLeft(array("c_dis" => "cidade"), "c_dis.cid_codigo=dis.cid_codigo", array("cid_nome_dis" => "cid_nome", "cid_codigo_dis" => "cid_codigo"))
            ->joinLeft(array("cid" => "cidade"), "cid.cid_codigo=bai.cid_codigo", array("cid_nome", "cid_codigo"))
            ->where("dom.dom_codigo = $dom_codigo")
            ->order(array("dom_numero", "rua_nome", "rua_bairro"));
//        die($where);
        return $this->fetchRow($where);
    }

    public function buscaDomicilio($term)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("d" => "domicilio"), array("dom_codigo", "dom_numero"))
            ->join(array("r" => "rua"), "d.rua_codigo=r.rua_codigo", array("rua_nome", "rua_cep", "rua_bairro"))
            ->where("r.rua_nome ilike retira_acentos('%$term%')")
            ->orwhere("d.dom_numero::varchar ilike '%$term%'")
            ->order("dom_numero")
            ->order("rua_nome");
        $all = $this->fetchAll($sql);
        $out = array();
        foreach ($all as $usu) {
            $data = $usu->toArray();
            $out [] = array(
                "id" => $usu->dom_codigo,
                "label" => $usu->rua_nome,
                "data" => $data
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array("dom_codigo" => "0", "dom_numero" => "", "rua_nome" => "", "rua_cep" => "", "rua_bairro" => "")
            );
        }
        return $out;
    }

    /**
     * Atualiza todas os domicilios, alterando sua rua.
     * Método usado para tirar a duplicação de ruas
     * @see Application_Model_Rua::removerDuplicacoes()
     * @param array|int $de
     * @param int $para
     * @return int Número de linhas atualizadas
     */
    public function atualizarRua($de, $para)
    {
        $de = (array)$de;

        $data = array("rua_codigo" => $para);
        $where = $this->select()->where("rua_codigo IN (?)", $de)->getPart(Zend_Db_Table_Select::WHERE);
        $where = $where[0];

        return $this->update($data, $where);
    }

    public function getDomicilios()
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("d" => "domicilio"),
                array(
                    "dom_codigo",
                    "COALESCE(dom_complemento,'&nbsp;') as dom_complemento",
                    "(CASE WHEN cast( cast( dom_numero as integer ) as char ) = '0' THEN 'S/N' ELSE cast( cast( dom_numero as integer ) as char(60) ) END) AS dom_numero"
                )
            )
            ->join(array("r" => "rua"), "d.rua_codigo=r.rua_codigo",
                array("(ds_tipo_logradouro ||' '||r.rua_nome) as rua_nome", "rua_cep")
            )
            ->joinLeft(array("b" => "bairro"), "b.bai_codigo=r.bai_codigo", array("bai_nome"))
            ->joinLeft(array("u" => "usuario"), "u.usu_codigo=d.usu_codigo_responsavel", array("usu_nome"))
            ->join(array("tpl" => "tb_ms_tipo_logradouro"), "tpl.co_tipo_logradouro=r.co_tipo_logradouro")
            ->order("dom_codigo DESC")
            ->limit(15);

        return $this->fetchAll($sql);
    }

    public function getDomicilio($dom_codigo)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("d" => "domicilio"),
                array(
                    "dom_codigo",
                    "COALESCE(dom_complemento,'&nbsp;') as dom_complemento",
                    "(CASE WHEN cast( cast( dom_numero as integer ) as char ) = '0' THEN 'S/N' ELSE cast( cast( dom_numero as integer ) as char(60) ) END) AS dom_numero"
                )
            )
            ->join(array("r" => "rua"), "d.rua_codigo=r.rua_codigo",
                array(
                    "rua_codigo",
                    "(ds_tipo_logradouro ||' '||r.rua_nome) as rua_nome",
                    "rua_cep"
                )
            )
            ->joinLeft(array("b" => "bairro"), "b.bai_codigo=r.bai_codigo", array("bai_codigo", "bai_nome"))
            ->joinLeft(array("cid" => "cidade"), "cid.cid_codigo=b.cid_codigo", array("cid_nome"))
            ->joinLeft(array("dis" => "distrito"), "dis.dis_codigo=b.dis_codigo", "dis_nome")
            ->joinLeft(array("cid2" => "cidade"), "cid2.cid_codigo=dis.cid_codigo", array("cid_distrito" => "cid_nome"))
            ->joinLeft(array("u" => "usuario"), "u.usu_codigo=d.usu_codigo_responsavel", array("usu_nome"))
            ->join(array("tpl" => "tb_ms_tipo_logradouro"), "tpl.co_tipo_logradouro=r.co_tipo_logradouro")
            ->where("d.dom_codigo=$dom_codigo")
            ->order("d.dom_codigo DESC");

        return $this->fetchRow($where);
    }

    public function getDomicilioPorRua($rua_codigo)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("d" => "domicilio"),
                array(
                    "dom_codigo",
                    "COALESCE(dom_complemento,'&nbsp;') as dom_complemento",
                    "(CASE WHEN cast( cast( dom_numero as integer ) as char ) = '0' THEN 'S/N' ELSE cast( cast( dom_numero as integer ) as char(60) ) END) AS dom_numero"
                )
            )
            ->join(array("r" => "rua"), "d.rua_codigo=r.rua_codigo",
                array(
                    "rua_codigo",
                    "(ds_tipo_logradouro ||' '||r.rua_nome) as rua_nome",
                    "rua_cep"
                )
            )
            ->joinLeft(array("b" => "bairro"), "b.bai_codigo=r.bai_codigo", array("bai_codigo", "bai_nome"))
            ->joinLeft(array("cid" => "cidade"), "cid.cid_codigo=b.cid_codigo", array("cid_nome", "uf_sigla"))
            ->joinLeft(array("dis" => "distrito"), "dis.dis_codigo=b.dis_codigo", "dis_nome")
            ->joinLeft(array("cid2" => "cidade"), "cid2.cid_codigo=dis.cid_codigo", array("cid_distrito" => "cid_nome"))
            ->joinLeft(array("u" => "usuario"), "u.usu_codigo=d.usu_codigo_responsavel", array("usu_nome"))
            ->join(array("tpl" => "tb_ms_tipo_logradouro"), "tpl.co_tipo_logradouro=r.co_tipo_logradouro")
            ->where("d.rua_codigo=$rua_codigo")
            ->order("d.dom_codigo DESC");
        return $this->fetchAll($where);
    }

    public function pesquisar($dados = NULL)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("d" => "domicilio"),
                array(
                    "dom_codigo",
                    "COALESCE(dom_complemento,'&nbsp;') as dom_complemento",
                    "(CASE WHEN cast( cast( dom_numero as integer ) as char ) = '0' THEN 'S/N' ELSE cast( cast( dom_numero as integer ) as char(60) ) END) AS dom_numero"
                )
            )
            ->join(array("r" => "rua"), "d.rua_codigo=r.rua_codigo",
                array("(ds_tipo_logradouro ||' '||r.rua_nome) as rua_nome", "rua_cep")
            )
            ->joinLeft(array("b" => "bairro"), "b.bai_codigo=r.bai_codigo", array("bai_nome"))
            ->joinLeft(array("u" => "usuario"), "u.usu_codigo=d.usu_codigo_responsavel", array("usu_nome"))
            ->join(array("tpl" => "tb_ms_tipo_logradouro"), "tpl.co_tipo_logradouro=r.co_tipo_logradouro")
            ->order("dom_codigo DESC");

        if (is_string($dados)) {
            $where->where("
                     r.rua_nome ilike '%$dados%' 
                  or b.bai_nome ilike '%$dados%' 
                  or u.usu_nome ilike '%$dados%' 
                  or d.dom_complemento ilike '%$dados%' 
                ");
        }

        return $this->fetchAll($where);
    }

    public function removeResponsavelDomicilio($cod_responsavel){
        if ($cod_responsavel) {
            $data = array("usu_codigo_responsavel" => null);
            $where = $this->select(array("domicilio"))->where("usu_codigo_responsavel = ?", $cod_responsavel)->getPart(Zend_Db_Table_Select::WHERE);
            $where = $where[0];
            return $this->update($data, $where);
        }
    }

}
